/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.filter.GenericFilterBean;

@Component
@Order(value=-2147483638)
public class CorsFilter
extends GenericFilterBean {
    private static final String ALLOW_HEADERS = StringUtils.joinWith((String)",", (Object[])new Object[]{"Content-Type", "ADMIN-Authorization", "API-Authorization"});

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String originHeaderValue = httpServletRequest.getHeader("Origin");
        if (StringUtils.isNotBlank((CharSequence)originHeaderValue)) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", originHeaderValue);
        }
        httpServletResponse.setHeader("Access-Control-Allow-Headers", ALLOW_HEADERS);
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpServletResponse.setHeader("Access-Control-Max-Age", "3600");
        if (!CorsUtils.isPreFlightRequest((HttpServletRequest)httpServletRequest)) {
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }
}

