/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import run.halo.app.utils.ServletUtils;

@Component
@Order(value=-2147483648)
public class LogFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LogFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String remoteAddr = ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        log.debug("Starting url: [{}], method: [{}], ip: [{}]", new Object[]{request.getRequestURL(), request.getMethod(), remoteAddr});
        long startTime = System.currentTimeMillis();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        log.debug("Ending   url: [{}], method: [{}], ip: [{}], status: [{}], usage: [{}] ms", new Object[]{request.getRequestURL(), request.getMethod(), remoteAddr, response.getStatus(), System.currentTimeMillis() - startTime});
    }
}

