/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.PutObjectResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.BaiduBosProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.service.OptionService;

@Component
public class BaiduBosFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(BaiduBosFileHandler.class);
    private final OptionService optionService;
    private final AttachmentRepository attachmentRepository;

    public BaiduBosFileHandler(OptionService optionService, AttachmentRepository attachmentRepository) {
        this.optionService = optionService;
        this.attachmentRepository = attachmentRepository;
    }

    public UploadResult upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        Object protocol = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_PROTOCOL);
        Object domain = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)BaiduBosProperties.BOS_DOMAIN, String.class, (Object)"");
        String endPoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_ENDPOINT).toString();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_ACCESS_KEY).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_SECRET_KEY).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_BUCKET_NAME).toString();
        String styleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)BaiduBosProperties.BOS_STYLE_RULE, String.class, (Object)"");
        String thumbnailStyleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)BaiduBosProperties.BOS_THUMBNAIL_STYLE_RULE, String.class, (Object)"");
        String source = StringUtils.join((Object[])new Object[]{protocol, bucketName, "." + endPoint});
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(accessKey, secretKey));
        config.setEndpoint(endPoint);
        BosClient client = new BosClient(config);
        domain = protocol + (String)domain;
        try {
            FilePathDescriptor pathDescriptor = new FilePathDescriptor.Builder().setBasePath((String)domain).setSubPath(source).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.BAIDUBOS) > 0L).setOriginalName(file.getOriginalFilename()).build();
            PutObjectResponse putObjectResponseFromInputStream = client.putObject(bucketName, pathDescriptor.getFullName(), file.getInputStream());
            if (putObjectResponseFromInputStream == null) {
                throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u767e\u5ea6\u4e91\u5931\u8d25 ");
            }
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(pathDescriptor.getFullName());
            String fullPath = pathDescriptor.getFullPath();
            uploadResult.setFilePath((String)(StringUtils.isBlank((CharSequence)styleRule) ? fullPath : fullPath + styleRule));
            uploadResult.setKey(pathDescriptor.getRelativePath());
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSuffix(pathDescriptor.getExtension());
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> {
                if ("ico".equals(pathDescriptor.getExtension())) {
                    return fullPath;
                }
                return StringUtils.isBlank((CharSequence)thumbnailStyleRule) ? fullPath : fullPath + thumbnailStyleRule;
            });
            UploadResult uploadResult2 = uploadResult;
            return uploadResult2;
        }
        catch (Exception e) {
            throw new FileOperationException("\u9644\u4ef6 " + file.getOriginalFilename() + " \u4e0a\u4f20\u5931\u8d25(\u767e\u5ea6\u4e91)", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    public void delete(String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        String endPoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_ENDPOINT).toString();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_ACCESS_KEY).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_SECRET_KEY).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)BaiduBosProperties.BOS_BUCKET_NAME).toString();
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(accessKey, secretKey));
        config.setEndpoint(endPoint);
        BosClient client = new BosClient(config);
        try {
            client.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u767e\u5ea6\u4e91\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.BAIDUBOS;
    }
}

