/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.imageio.ImageReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.support.HaloConst;
import run.halo.app.model.support.UploadResult;
import run.halo.app.utils.ImageUtils;

public interface FileHandler {
    public static final MediaType IMAGE_TYPE = MediaType.valueOf((String)"image/*");

    @NonNull
    public static String normalizeDirectory(@NonNull String dir) {
        Assert.hasText((String)dir, (String)"Directory full name must not be blank");
        return StringUtils.appendIfMissing((String)dir, (CharSequence)HaloConst.FILE_SEPARATOR, (CharSequence[])new CharSequence[0]);
    }

    @NonNull
    public UploadResult upload(@NonNull MultipartFile var1);

    default public boolean isImageType(@NonNull MultipartFile file) {
        String mediaType = file.getContentType();
        return mediaType != null && IMAGE_TYPE.includes(MediaType.valueOf((String)mediaType));
    }

    default public void handleImageMetadata(@NonNull MultipartFile file, @NonNull UploadResult uploadResult, @Nullable Supplier<String> thumbnailSupplier) {
        if (this.isImageType(file)) {
            try (InputStream is = file.getInputStream();){
                String extension = uploadResult.getSuffix();
                if ("ico".equals(extension)) {
                    BufferedImage icoImage = ImageUtils.getImageFromFile((InputStream)is, (String)extension);
                    uploadResult.setWidth(Integer.valueOf(icoImage.getWidth()));
                    uploadResult.setHeight(Integer.valueOf(icoImage.getHeight()));
                } else {
                    ImageReader image = ImageUtils.getImageReaderFromFile((InputStream)is, (String)extension);
                    uploadResult.setWidth(Integer.valueOf(image.getWidth(0)));
                    uploadResult.setHeight(Integer.valueOf(image.getHeight(0)));
                }
                if (thumbnailSupplier != null) {
                    uploadResult.setThumbPath(thumbnailSupplier.get());
                }
            }
            catch (IOException | OutOfMemoryError e) {
                LoggerFactory.getLogger(this.getClass()).warn("Failed to fetch image meta data", e);
            }
        }
        if (StringUtils.isBlank((CharSequence)uploadResult.getThumbPath())) {
            uploadResult.setThumbPath(uploadResult.getFilePath());
        }
    }

    public void delete(@NonNull String var1);

    public AttachmentType getAttachmentType();
}

