/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import com.obs.services.ObsClient;
import com.obs.services.model.PutObjectResult;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.HuaweiObsProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.service.OptionService;

@Component
public class HuaweiObsFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(HuaweiObsFileHandler.class);
    private final OptionService optionService;
    private final AttachmentRepository attachmentRepository;

    public HuaweiObsFileHandler(OptionService optionService, AttachmentRepository attachmentRepository) {
        this.optionService = optionService;
        this.attachmentRepository = attachmentRepository;
    }

    @NonNull
    public UploadResult upload(@NonNull MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        String protocol = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_PROTOCOL).toString();
        String domain = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)HuaweiObsProperties.OSS_DOMAIN, String.class, (Object)"");
        String source = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)HuaweiObsProperties.OSS_SOURCE, String.class, (Object)"");
        String endPoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ENDPOINT).toString();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ACCESS_KEY).toString();
        String accessSecret = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ACCESS_SECRET).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_BUCKET_NAME).toString();
        String styleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)HuaweiObsProperties.OSS_STYLE_RULE, String.class, (Object)"");
        String thumbnailStyleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)HuaweiObsProperties.OSS_THUMBNAIL_STYLE_RULE, String.class, (Object)"");
        ObsClient obsClient = new ObsClient(accessKey, accessSecret, endPoint);
        StringBuilder basePath = new StringBuilder(protocol);
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            basePath.append(domain).append("/");
        } else {
            basePath.append(bucketName).append(".").append(endPoint).append("/");
        }
        try {
            FilePathDescriptor pathDescriptor = new FilePathDescriptor.Builder().setBasePath(basePath.toString()).setSubPath(source).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.HUAWEIOBS) > 0L).setOriginalName(file.getOriginalFilename()).build();
            log.info(basePath.toString());
            PutObjectResult putObjectResult = obsClient.putObject(bucketName, pathDescriptor.getRelativePath(), file.getInputStream());
            if (putObjectResult == null) {
                throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u534e\u4e3a\u4e91\u5931\u8d25 ");
            }
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(pathDescriptor.getName());
            String fullPath = pathDescriptor.getFullPath();
            uploadResult.setFilePath((String)(StringUtils.isBlank((CharSequence)styleRule) ? fullPath : fullPath + styleRule));
            uploadResult.setKey(pathDescriptor.getRelativePath());
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSuffix(pathDescriptor.getExtension());
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> {
                if ("ico".equals(pathDescriptor.getExtension())) {
                    return fullPath;
                }
                return StringUtils.isBlank((CharSequence)thumbnailStyleRule) ? fullPath : fullPath + thumbnailStyleRule;
            });
            log.info("Uploaded file: [{}] successfully", (Object)file.getOriginalFilename());
            UploadResult uploadResult2 = uploadResult;
            return uploadResult2;
        }
        catch (Exception e) {
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u534e\u4e3a\u4e91\u5931\u8d25 ", (Throwable)e).setErrorData((Object)file.getOriginalFilename());
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    public void delete(@NonNull String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        String endPoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ENDPOINT).toString();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ACCESS_KEY).toString();
        String accessSecret = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_ACCESS_SECRET).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)HuaweiObsProperties.OSS_BUCKET_NAME).toString();
        ObsClient obsClient = new ObsClient(accessKey, accessSecret, endPoint);
        try {
            obsClient.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u534e\u4e3a\u4e91\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.HUAWEIOBS;
    }
}

