/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Objects;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.support.HaloConst;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.utils.FilenameUtils;
import run.halo.app.utils.ImageUtils;

@Component
public class LocalFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalFileHandler.class);
    private static final String UPLOAD_SUB_DIR = "upload/";
    private static final String THUMBNAIL_SUFFIX = "-thumbnail";
    private static final int THUMB_WIDTH = 256;
    private static final int THUMB_HEIGHT = 256;
    private final AttachmentRepository attachmentRepository;
    private final String workDir;

    public LocalFileHandler(AttachmentRepository attachmentRepository, HaloProperties haloProperties) {
        this.attachmentRepository = attachmentRepository;
        this.workDir = FileHandler.normalizeDirectory((String)haloProperties.getWorkDir());
        this.checkWorkDir();
    }

    private void checkWorkDir() {
        Path workPath = Paths.get(this.workDir, new String[0]);
        if (!(Files.isDirectory(workPath, new LinkOption[0]) && Files.isReadable(workPath) && Files.isWritable(workPath))) {
            log.warn("Please make sure that {} is a directory, readable and writable!", (Object)this.workDir);
        }
    }

    @NonNull
    public UploadResult upload(@NonNull MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        FilePathDescriptor uploadFilePath = new FilePathDescriptor.Builder().setBasePath(this.workDir).setSubPath(this.generatePath()).setSeparator(HaloConst.FILE_SEPARATOR).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.LOCAL) > 0L).setOriginalName(file.getOriginalFilename()).build();
        log.info("Uploading file: [{}] to directory: [{}]", (Object)file.getOriginalFilename(), (Object)uploadFilePath.getRelativePath());
        Path localFileFullPath = Paths.get(uploadFilePath.getFullPath(), new String[0]);
        try {
            Files.createDirectories(localFileFullPath.getParent(), new FileAttribute[0]);
            Files.createFile(localFileFullPath, new FileAttribute[0]);
            file.transferTo(localFileFullPath);
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(uploadFilePath.getName());
            uploadResult.setFilePath(uploadFilePath.getRelativePath());
            uploadResult.setKey(uploadFilePath.getRelativePath());
            uploadResult.setSuffix(uploadFilePath.getExtension());
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> {
                FilePathDescriptor thumbnailFilePath = new FilePathDescriptor.Builder().setBasePath(this.workDir).setSubPath(uploadFilePath.getSubPath()).setSeparator(HaloConst.FILE_SEPARATOR).setOriginalName(uploadFilePath.getFullName()).setNameSuffix(THUMBNAIL_SUFFIX).build();
                Path thumbnailPath = Paths.get(thumbnailFilePath.getFullPath(), new String[0]);
                try (InputStream is = file.getInputStream();){
                    BufferedImage originalImage = ImageUtils.getImageFromFile((InputStream)is, (String)uploadFilePath.getExtension());
                    boolean result = this.generateThumbnail(originalImage, thumbnailPath, uploadFilePath.getExtension());
                    if (!result) return uploadFilePath.getRelativePath();
                    String string = thumbnailFilePath.getRelativePath();
                    return string;
                }
                catch (Throwable e) {
                    log.warn("Failed to open image file.", e);
                }
                return uploadFilePath.getRelativePath();
            });
            log.info("Uploaded file: [{}] to directory: [{}] successfully", (Object)file.getOriginalFilename(), (Object)uploadFilePath.getFullPath());
            return uploadResult;
        }
        catch (IOException e) {
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25").setErrorData((Object)uploadFilePath.getFullPath());
        }
    }

    public void delete(String key) {
        Assert.hasText((String)key, (String)"File key must not be blank");
        Path path = Paths.get(this.workDir, key);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        String basename = FilenameUtils.getBasename((String)key);
        String extension = FilenameUtils.getExtension((String)key);
        String thumbnailName = basename + "-thumbnail." + extension;
        Path thumbnailPath = Paths.get(path.getParent().toString(), thumbnailName);
        try {
            boolean deleteResult = Files.deleteIfExists(thumbnailPath);
            if (!deleteResult) {
                log.warn("Thumbnail: [{}] may not exist", (Object)thumbnailPath.toString());
            }
        }
        catch (IOException e) {
            throw new FileOperationException("\u9644\u4ef6\u7f29\u7565\u56fe " + thumbnailName + " \u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.LOCAL;
    }

    private String generatePath() {
        Calendar current = Calendar.getInstance();
        int year = current.get(1);
        int month = current.get(2) + 1;
        Object monthString = month < 10 ? "0" + month : String.valueOf(month);
        return UPLOAD_SUB_DIR + year + HaloConst.FILE_SEPARATOR + (String)monthString + HaloConst.FILE_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateThumbnail(BufferedImage originalImage, Path thumbPath, String extension) {
        Assert.notNull((Object)originalImage, (String)"Image must not be null");
        Assert.notNull((Object)thumbPath, (String)"Thumb path must not be null");
        boolean result = false;
        try {
            Files.createFile(thumbPath, new FileAttribute[0]);
            log.debug("Trying to generate thumbnail: [{}]", (Object)thumbPath);
            Thumbnails.of((BufferedImage[])new BufferedImage[]{originalImage}).size(256, 256).keepAspectRatio(true).toFile(thumbPath.toFile());
            log.info("Generated thumbnail image, and wrote the thumbnail to [{}]", (Object)thumbPath);
            result = true;
        }
        catch (Throwable t) {
            log.warn("Failed to generate thumbnail: " + thumbPath, t);
        }
        finally {
            originalImage.getGraphics().dispose();
        }
        return result;
    }
}

