/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.MinioProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.service.OptionService;

@Component
public class MinioFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(MinioFileHandler.class);
    private final OptionService optionService;
    private final AttachmentRepository attachmentRepository;

    public MinioFileHandler(OptionService optionService, AttachmentRepository attachmentRepository) {
        this.optionService = optionService;
        this.attachmentRepository = attachmentRepository;
    }

    @NonNull
    public UploadResult upload(@NonNull MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        String endpoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ENDPOINT).toString();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ACCESS_KEY).toString();
        String accessSecret = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ACCESS_SECRET).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.BUCKET_NAME).toString();
        String source = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)MinioProperties.SOURCE, String.class, (Object)"");
        String region = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)MinioProperties.REGION, String.class, (Object)"us-east-1");
        endpoint = StringUtils.appendIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        MinioClient minioClient = MinioClient.builder().endpoint(endpoint).credentials(accessKey, accessSecret).region(region).build();
        try {
            FilePathDescriptor pathDescriptor = new FilePathDescriptor.Builder().setBasePath(endpoint + bucketName).setSubPath(source).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.MINIO) > 0L).setOriginalName(file.getOriginalFilename()).build();
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().contentType(file.getContentType()).bucket(bucketName)).stream(file.getInputStream(), file.getSize(), -1L).object(pathDescriptor.getRelativePath())).build();
            minioClient.ignoreCertCheck();
            minioClient.putObject(putObjectArgs);
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(pathDescriptor.getName());
            uploadResult.setFilePath(pathDescriptor.getFullPath());
            uploadResult.setKey(pathDescriptor.getRelativePath());
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSuffix(pathDescriptor.getExtension());
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> ((FilePathDescriptor)pathDescriptor).getFullPath());
            return uploadResult;
        }
        catch (Exception e) {
            log.error("upload file to MINIO failed", (Throwable)e);
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230 MinIO \u5931\u8d25 ", (Throwable)e).setErrorData((Object)e.getMessage());
        }
    }

    public void delete(@NonNull String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        String endPoint = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ENDPOINT).toString();
        endPoint = StringUtils.appendIfMissing((String)endPoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ACCESS_KEY).toString();
        String accessSecret = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.ACCESS_SECRET).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)MinioProperties.BUCKET_NAME).toString();
        String region = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)MinioProperties.REGION, String.class, (Object)"us-east-1");
        MinioClient minioClient = MinioClient.builder().endpoint(endPoint).credentials(accessKey, accessSecret).region(region).build();
        try {
            minioClient.ignoreCertCheck();
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(key)).build());
        }
        catch (Exception e) {
            log.error("delete MINIO file: [{}] failed", (Object)key, (Object)e);
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece MinIO \u5220\u9664\u5931\u8d25", (Throwable)e).setErrorData((Object)e.getMessage());
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.MINIO;
    }
}

