/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.handler.file.QiniuOssFileHandler;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.QiniuOssProperties;
import run.halo.app.model.support.HaloConst;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.service.OptionService;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.JsonUtils;

@Component
public class QiniuOssFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(QiniuOssFileHandler.class);
    private final OptionService optionService;
    private final AttachmentRepository attachmentRepository;

    public QiniuOssFileHandler(OptionService optionService, AttachmentRepository attachmentRepository) {
        this.optionService = optionService;
        this.attachmentRepository = attachmentRepository;
    }

    public UploadResult upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        Region region = this.optionService.getQiniuRegion();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_ACCESS_KEY).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_SECRET_KEY).toString();
        String bucket = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_BUCKET).toString();
        String protocol = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_PROTOCOL).toString();
        String domain = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_DOMAIN).toString();
        String source = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)QiniuOssProperties.OSS_SOURCE, String.class, (Object)"");
        String styleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)QiniuOssProperties.OSS_STYLE_RULE, String.class, (Object)"");
        String thumbnailStyleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)QiniuOssProperties.OSS_THUMBNAIL_STYLE_RULE, String.class, (Object)"");
        Configuration configuration = new Configuration(region);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        StringMap putPolicy = new StringMap();
        putPolicy.put("returnBody", (Object)"{\"key\":\"$(key)\",\"hash\":\"$(etag)\",\"size\":$(fsize),\"width\":$(imageInfo.width),\"height\":$(imageInfo.height)}");
        String uploadToken = auth.uploadToken(bucket, null, 3600L, putPolicy);
        Path tmpPath = Paths.get(HaloUtils.ensureSuffix((String)HaloConst.TEMP_DIR, (String)HaloConst.FILE_SEPARATOR), bucket);
        StringBuilder basePath = new StringBuilder(protocol).append(domain).append("/");
        try {
            FilePathDescriptor pathDescriptor = new FilePathDescriptor.Builder().setBasePath(basePath.toString()).setSubPath(source).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.QINIUOSS) > 0L).setOriginalName(file.getOriginalFilename()).build();
            FileRecorder fileRecorder = new FileRecorder(tmpPath.toFile());
            UploadManager uploadManager = new UploadManager(configuration, (Recorder)fileRecorder);
            Response response = uploadManager.put(file.getInputStream(), pathDescriptor.getRelativePath(), uploadToken, null, null);
            if (log.isDebugEnabled()) {
                log.debug("Qiniu oss response: [{}]", (Object)response.toString());
                log.debug("Qiniu oss response body: [{}]", (Object)response.bodyString());
            }
            PutSet putSet = (PutSet)JsonUtils.jsonToObject((String)response.bodyString(), PutSet.class);
            String fullPath = pathDescriptor.getFullPath();
            UploadResult result = new UploadResult();
            result.setFilename(pathDescriptor.getName());
            result.setFilePath((String)(StringUtils.isBlank((CharSequence)styleRule) ? fullPath : fullPath + styleRule));
            result.setKey(pathDescriptor.getRelativePath());
            result.setSuffix(pathDescriptor.getExtension());
            result.setWidth(putSet.getWidth());
            result.setHeight(putSet.getHeight());
            result.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            result.setSize(Long.valueOf(file.getSize()));
            if (this.isImageType(file)) {
                if ("ico".equals(pathDescriptor.getExtension())) {
                    result.setThumbPath(fullPath);
                } else {
                    result.setThumbPath((String)(StringUtils.isBlank((CharSequence)thumbnailStyleRule) ? fullPath : fullPath + thumbnailStyleRule));
                }
            }
            return result;
        }
        catch (IOException e) {
            if (e instanceof QiniuException) {
                log.error("Qiniu oss error response: [{}]", (Object)((QiniuException)e).response);
            }
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u4e03\u725b\u4e91\u5931\u8d25", (Throwable)e);
        }
    }

    public void delete(String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        Region region = this.optionService.getQiniuRegion();
        String accessKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_ACCESS_KEY).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_SECRET_KEY).toString();
        String bucket = this.optionService.getByPropertyOfNonNull((PropertyEnum)QiniuOssProperties.OSS_BUCKET).toString();
        Configuration configuration = new Configuration(region);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        BucketManager bucketManager = new BucketManager(auth, configuration);
        try {
            Response response = bucketManager.delete(bucket, key);
            if (!response.isOK()) {
                log.warn("\u9644\u4ef6 " + key + " \u4ece\u4e03\u725b\u4e91\u5220\u9664\u5931\u8d25");
                throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u4e03\u725b\u4e91\u5220\u9664\u5931\u8d25");
            }
        }
        catch (QiniuException e) {
            log.error("Qiniu oss error response: [{}]", (Object)e.response);
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u4e03\u725b\u4e91\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.QINIUOSS;
    }
}

