/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.exception.ServiceException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.SmmsFileHandler;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.SmmsProperties;
import run.halo.app.model.support.HaloConst;
import run.halo.app.model.support.UploadResult;
import run.halo.app.service.OptionService;
import run.halo.app.utils.FilenameUtils;
import run.halo.app.utils.HttpClientUtils;

@Component
public class SmmsFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(SmmsFileHandler.class);
    @Deprecated
    private static final String UPLOAD_API = "https://sm.ms/api/upload";
    private static final String UPLOAD_API_V2 = "https://sm.ms/api/v2/upload";
    @Deprecated
    private static final String DELETE_API = "https://sm.ms/api/delete/%s";
    private static final String DELETE_API_V2 = "https://sm.ms/api/v2/delete/%s";
    private static final String SUCCESS_CODE = "success";
    private final RestTemplate httpsRestTemplate;
    private final OptionService optionService;
    private final HttpHeaders headers = new HttpHeaders();

    public SmmsFileHandler(RestTemplate httpsRestTemplate, OptionService optionService) {
        this.httpsRestTemplate = httpsRestTemplate;
        this.optionService = optionService;
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
        this.httpsRestTemplate.getMessageConverters().add(mappingJackson2HttpMessageConverter);
    }

    public UploadResult upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        String apiSecretToken = this.optionService.getByPropertyOfNonNull((PropertyEnum)SmmsProperties.SMMS_API_SECRET_TOKEN).toString();
        if (StringUtils.isEmpty((Object)apiSecretToken)) {
            throw new ServiceException("\u8bf7\u5148\u8bbe\u7f6e SM.MS \u7684 Secret Token");
        }
        if (!this.isImageType(file)) {
            log.error("Invalid extension: [{}]", (Object)file.getContentType());
            throw new FileOperationException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301 \"jpeg, jpg, png, gif, bmp\" \u683c\u5f0f\u7684\u56fe\u7247");
        }
        this.setHeaders();
        this.headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        try {
            body.add((Object)"smfile", (Object)new HttpClientUtils.MultipartFileResource(file.getBytes(), file.getOriginalFilename()));
        }
        catch (IOException e) {
            log.error("Failed to get file input stream", (Throwable)e);
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230 SM.MS \u5931\u8d25", (Throwable)e);
        }
        body.add((Object)"format", (Object)"json");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)this.headers);
        ResponseEntity mapResponseEntity = this.httpsRestTemplate.postForEntity(UPLOAD_API_V2, (Object)httpEntity, SmmsResponse.class, new Object[0]);
        if (mapResponseEntity.getStatusCode().isError()) {
            log.error("Server response detail: [{}]", (Object)mapResponseEntity);
            throw new FileOperationException("SM.MS \u670d\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u72b6\u6001\u7801: " + mapResponseEntity.getStatusCodeValue());
        }
        SmmsResponse smmsResponse = (SmmsResponse)mapResponseEntity.getBody();
        if (!this.isResponseSuccessfully(smmsResponse)) {
            log.error("Smms response detail: [{}]", (Object)smmsResponse);
            throw new FileOperationException(smmsResponse == null ? "SM.MS \u670d\u52a1\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a" : smmsResponse.getMessage()).setErrorData((Object)smmsResponse);
        }
        if (!smmsResponse.getSuccess().booleanValue()) {
            throw new FileOperationException("\u4e0a\u4f20\u8bf7\u6c42\u5931\u8d25\uff1a" + smmsResponse.getMessage()).setErrorData((Object)smmsResponse);
        }
        SmmsResponseData data = smmsResponse.getData();
        UploadResult result = new UploadResult();
        result.setFilename(FilenameUtils.getBasename((String)Objects.requireNonNull(file.getOriginalFilename())));
        result.setSuffix(FilenameUtils.getExtension((String)file.getOriginalFilename()));
        result.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
        result.setFilePath(data.getUrl());
        result.setThumbPath(data.getUrl());
        result.setKey(data.getHash());
        result.setWidth(data.getWidth());
        result.setHeight(data.getHeight());
        result.setSize(Long.valueOf(data.getSize().longValue()));
        log.info("File: [{}] uploaded successfully", (Object)file.getOriginalFilename());
        return result;
    }

    public void delete(String key) {
        Assert.hasText((String)key, (String)"Deleting key must not be blank");
        String url = String.format(DELETE_API_V2, key);
        this.setHeaders();
        ResponseEntity responseEntity = this.httpsRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)this.headers), String.class, new Object[0]);
        if (responseEntity.getStatusCode().isError()) {
            log.debug("Smms server response error: [{}]", (Object)responseEntity.toString());
            throw new FileOperationException("SM.MS \u670d\u52a1\u72b6\u6001\u5f02\u5e38");
        }
        log.debug("Smms response detail: [{}]", responseEntity.getBody());
        log.info("File was deleted successfully or had been deleted already");
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.SMMS;
    }

    private boolean isResponseSuccessfully(@Nullable SmmsResponse smmsResponse) {
        return smmsResponse != null && smmsResponse.getCode().equals(SUCCESS_CODE);
    }

    private void setHeaders() {
        this.headers.set("User-Agent", "Halo/" + HaloConst.HALO_VERSION);
        this.headers.set("Authorization", this.optionService.getByPropertyOfNonNull((PropertyEnum)SmmsProperties.SMMS_API_SECRET_TOKEN).toString());
    }
}

