/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.handler.file.FilePathDescriptor;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.TencentCosProperties;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.service.OptionService;

@Component
public class TencentCosFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(TencentCosFileHandler.class);
    private final OptionService optionService;
    private final AttachmentRepository attachmentRepository;

    public TencentCosFileHandler(OptionService optionService, AttachmentRepository attachmentRepository) {
        this.optionService = optionService;
        this.attachmentRepository = attachmentRepository;
    }

    public UploadResult upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        String protocol = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_PROTOCOL).toString();
        String domain = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)TencentCosProperties.COS_DOMAIN, String.class, (Object)"");
        String region = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_REGION).toString();
        String secretId = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_SECRET_ID).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_SECRET_KEY).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_BUCKET_NAME).toString();
        String source = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)TencentCosProperties.COS_SOURCE, String.class, (Object)"");
        String styleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)TencentCosProperties.COS_STYLE_RULE, String.class, (Object)"");
        String thumbnailStyleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)TencentCosProperties.COS_THUMBNAIL_STYLE_RULE, String.class, (Object)"");
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region regionConfig = new Region(region);
        ClientConfig clientConfig = new ClientConfig(regionConfig);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        StringBuilder basePath = new StringBuilder(protocol);
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            basePath.append(domain).append("/");
        } else {
            basePath.append(bucketName).append(".cos.").append(region).append(".myqcloud.com").append("/");
        }
        try {
            FilePathDescriptor pathDescriptor = new FilePathDescriptor.Builder().setBasePath(basePath.toString()).setSubPath(source).setAutomaticRename(Boolean.valueOf(true)).setRenamePredicate(relativePath -> this.attachmentRepository.countByFileKeyAndType(relativePath, AttachmentType.TENCENTCOS) > 0L).setOriginalName(file.getOriginalFilename()).build();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(file.getSize());
            objectMetadata.setContentType(file.getContentType());
            PutObjectResult putObjectResponseFromInputStream = cosClient.putObject(bucketName, pathDescriptor.getRelativePath(), file.getInputStream(), objectMetadata);
            if (putObjectResponseFromInputStream == null) {
                throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u817e\u8baf\u4e91\u5931\u8d25 ");
            }
            String fullPath = pathDescriptor.getFullPath();
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(pathDescriptor.getName());
            uploadResult.setFilePath((String)(StringUtils.isBlank((CharSequence)styleRule) ? fullPath : fullPath + styleRule));
            uploadResult.setKey(pathDescriptor.getRelativePath());
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSuffix(pathDescriptor.getExtension());
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> {
                if ("ico".equals(pathDescriptor.getExtension())) {
                    uploadResult.setThumbPath(fullPath);
                    return fullPath;
                }
                return StringUtils.isBlank((CharSequence)thumbnailStyleRule) ? fullPath : fullPath + thumbnailStyleRule;
            });
            UploadResult uploadResult2 = uploadResult;
            return uploadResult2;
        }
        catch (Exception e) {
            throw new FileOperationException("\u9644\u4ef6 " + file.getOriginalFilename() + " \u4e0a\u4f20\u5931\u8d25(\u817e\u8baf\u4e91)", (Throwable)e);
        }
        finally {
            cosClient.shutdown();
        }
    }

    public void delete(String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        String region = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_REGION).toString();
        String secretId = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_SECRET_ID).toString();
        String secretKey = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_SECRET_KEY).toString();
        String bucketName = this.optionService.getByPropertyOfNonNull((PropertyEnum)TencentCosProperties.COS_BUCKET_NAME).toString();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region regionConfig = new Region(region);
        ClientConfig clientConfig = new ClientConfig(regionConfig);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        try {
            cosClient.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u817e\u8baf\u4e91\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        finally {
            cosClient.shutdown();
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.TENCENTCOS;
    }
}

