/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.file;

import com.upyun.RestManager;
import com.upyun.UpException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.UpOssProperties;
import run.halo.app.model.support.UploadResult;
import run.halo.app.service.OptionService;
import run.halo.app.utils.FilenameUtils;

@Component
public class UpOssFileHandler
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(UpOssFileHandler.class);
    private final OptionService optionService;

    public UpOssFileHandler(OptionService optionService) {
        this.optionService = optionService;
    }

    public UploadResult upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        String source = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_SOURCE).toString();
        String password = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_PASSWORD).toString();
        String bucket = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_BUCKET).toString();
        String protocol = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_PROTOCOL).toString();
        String domain = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_DOMAIN).toString();
        String operator = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_OPERATOR).toString();
        String styleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)UpOssProperties.OSS_STYLE_RULE, String.class, (Object)"");
        String thumbnailStyleRule = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)UpOssProperties.OSS_THUMBNAIL_STYLE_RULE, String.class, (Object)"");
        RestManager manager = new RestManager(bucket, operator, password);
        manager.setTimeout(600);
        manager.setApiDomain("https://v0.api.upyun.com");
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String basename = FilenameUtils.getBasename((String)Objects.requireNonNull(file.getOriginalFilename()));
            String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
            String md5OfFile = DigestUtils.md5DigestAsHex((InputStream)file.getInputStream());
            String upFilePath = StringUtils.appendIfMissing((String)source, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + md5OfFile + "." + extension;
            params.put(RestManager.PARAMS.CONTENT_MD5.getValue(), md5OfFile);
            Response result = manager.writeFile(upFilePath, file.getInputStream(), params);
            if (!result.isSuccessful()) {
                throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u53c8\u62cd\u4e91\u5931\u8d25" + upFilePath);
            }
            String filePath = protocol + StringUtils.removeEnd((String)domain, (String)"/") + upFilePath;
            UploadResult uploadResult = new UploadResult();
            uploadResult.setFilename(basename);
            uploadResult.setFilePath(StringUtils.isBlank((CharSequence)styleRule) ? filePath : filePath + styleRule);
            uploadResult.setKey(upFilePath);
            uploadResult.setMediaType(MediaType.valueOf((String)Objects.requireNonNull(file.getContentType())));
            uploadResult.setSuffix(extension);
            uploadResult.setSize(Long.valueOf(file.getSize()));
            this.handleImageMetadata(file, uploadResult, () -> {
                if ("ico".equals(extension)) {
                    uploadResult.setThumbPath(filePath);
                    return filePath;
                }
                return StringUtils.isBlank((CharSequence)thumbnailStyleRule) ? filePath : filePath + thumbnailStyleRule;
            });
            result.close();
            return uploadResult;
        }
        catch (Exception e) {
            throw new FileOperationException("\u4e0a\u4f20\u9644\u4ef6 " + file.getOriginalFilename() + " \u5230\u53c8\u62cd\u4e91\u5931\u8d25", (Throwable)e);
        }
    }

    public void delete(String key) {
        Assert.notNull((Object)key, (String)"File key must not be blank");
        String password = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_PASSWORD).toString();
        String bucket = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_BUCKET).toString();
        String operator = this.optionService.getByPropertyOfNonNull((PropertyEnum)UpOssProperties.OSS_OPERATOR).toString();
        RestManager manager = new RestManager(bucket, operator, password);
        manager.setTimeout(600);
        manager.setApiDomain("https://v0.api.upyun.com");
        try {
            Response result = manager.deleteFile(key, null);
            if (!result.isSuccessful()) {
                log.warn("\u9644\u4ef6 " + key + " \u4ece\u53c8\u62cd\u4e91\u5220\u9664\u5931\u8d25");
                throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u53c8\u62cd\u4e91\u5220\u9664\u5931\u8d25");
            }
        }
        catch (UpException | IOException e) {
            e.printStackTrace();
            throw new FileOperationException("\u9644\u4ef6 " + key + " \u4ece\u53c8\u62cd\u4e91\u5220\u9664\u5931\u8d25", e);
        }
    }

    public AttachmentType getAttachmentType() {
        return AttachmentType.UPOSS;
    }
}

