/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.migrate;

import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.FileOperationException;
import run.halo.app.handler.migrate.MigrateHandler;
import run.halo.app.model.enums.MigrateType;

@Component
public class MigrateHandlers {
    private static final Logger log = LoggerFactory.getLogger(MigrateHandlers.class);
    private final Collection<MigrateHandler> migrateHandlers = new LinkedList();

    public MigrateHandlers(ApplicationContext applicationContext) {
        this.addMigrateHandlers(applicationContext.getBeansOfType(MigrateHandler.class).values());
    }

    @NonNull
    public void upload(@NonNull MultipartFile file, @NonNull MigrateType migrateType) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        Assert.notNull((Object)migrateType, (String)"Migrate type must not be null");
        for (MigrateHandler migrateHandler : this.migrateHandlers) {
            if (!migrateHandler.supportType(migrateType)) continue;
            migrateHandler.migrate(file);
            return;
        }
        throw new FileOperationException("No available migrate handler to migrate the file").setErrorData((Object)migrateType);
    }

    @NonNull
    private MigrateHandlers addMigrateHandlers(@Nullable Collection<MigrateHandler> migrateHandlers) {
        if (!CollectionUtils.isEmpty(migrateHandlers)) {
            this.migrateHandlers.addAll(migrateHandlers);
        }
        return this;
    }
}

