/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.handler.theme.config.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import run.halo.app.handler.theme.config.ThemeConfigResolver;
import run.halo.app.handler.theme.config.support.Group;
import run.halo.app.handler.theme.config.support.Item;
import run.halo.app.handler.theme.config.support.Option;
import run.halo.app.model.enums.DataType;
import run.halo.app.model.enums.InputType;

@Service
public class YamlThemeConfigResolverImpl
implements ThemeConfigResolver {
    private static final Logger log = LoggerFactory.getLogger(YamlThemeConfigResolverImpl.class);
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public List<Group> resolve(String content) throws IOException {
        return this.handleTabs(this.yamlMapper.readValue(content, Object.class));
    }

    private List<Group> handleTabs(@Nullable Object config) {
        LinkedList<Group> groups = new LinkedList<Group>();
        if (config instanceof List) {
            List configList = (List)config;
            configList.forEach(tabYaml -> {
                if (!(tabYaml instanceof Map)) {
                    return;
                }
                Map tabMap = (Map)tabYaml;
                Group group = new Group();
                group.setName(tabMap.get("name").toString());
                group.setLabel(tabMap.get("label").toString());
                group.setItems(this.handleItems(tabMap.get("items")));
                groups.add(group);
            });
        } else if (config instanceof Map) {
            Map configMap = (Map)config;
            configMap.forEach((key, value) -> {
                if (!(value instanceof Map)) {
                    return;
                }
                Map tabMap = (Map)value;
                Group group = new Group();
                group.setName(key.toString());
                group.setLabel(tabMap.get("label").toString());
                group.setItems(this.handleItems(tabMap.get("items")));
                groups.add(group);
            });
        }
        return groups;
    }

    private List<Item> handleItems(@Nullable Object items) {
        if (items == null) {
            return Collections.emptyList();
        }
        LinkedList<Item> result = new LinkedList<Item>();
        if (items instanceof List) {
            ((List)items).forEach(itemYaml -> {
                if (!(itemYaml instanceof Map)) {
                    return;
                }
                Map itemMap = (Map)itemYaml;
                Item item = new Item();
                item.setName(itemMap.get("name").toString());
                item.setLabel(itemMap.getOrDefault("label", item.getName()).toString());
                Object dataType = itemMap.getOrDefault("data-type", itemMap.get("dataType"));
                item.setType(InputType.typeOf(itemMap.get("type")));
                item.setDataType(item.getType().equals((Object)InputType.SWITCH) ? DataType.BOOL : DataType.typeOf(dataType));
                item.setDefaultValue(itemMap.get("default"));
                item.setPlaceholder(itemMap.getOrDefault("placeholder", "").toString());
                item.setDescription(itemMap.getOrDefault("description", "").toString());
                item.setOptions(this.handleOptions(itemMap.get("options")));
                result.add(item);
            });
        } else if (items instanceof Map) {
            Map itemsMap = (Map)items;
            itemsMap.forEach((key, value) -> {
                if (!(value instanceof Map)) {
                    return;
                }
                Map itemMap = (Map)value;
                Item item = new Item();
                item.setName(key.toString());
                item.setLabel(itemMap.getOrDefault("label", item.getName()).toString());
                Object dataType = itemMap.getOrDefault("data-type", itemMap.get("dataType"));
                item.setType(InputType.typeOf(itemMap.get("type")));
                item.setDataType(item.getType().equals((Object)InputType.SWITCH) ? DataType.BOOL : DataType.typeOf(dataType));
                item.setDefaultValue(itemMap.get("default"));
                item.setPlaceholder(itemMap.getOrDefault("placeholder", "").toString());
                item.setDescription(itemMap.getOrDefault("description", "").toString());
                item.setOptions(this.handleOptions(itemMap.get("options")));
                result.add(item);
            });
        }
        return result;
    }

    private List<Option> handleOptions(@Nullable Object options) {
        if (options == null) {
            return Collections.emptyList();
        }
        LinkedList<Option> result = new LinkedList<Option>();
        if (options instanceof List) {
            ((List)options).forEach(optionYaml -> {
                if (!(optionYaml instanceof Map)) {
                    return;
                }
                Map optionMap = (Map)optionYaml;
                Option option = new Option();
                option.setValue(optionMap.get("value"));
                option.setLabel(optionMap.get("label").toString());
                result.add(option);
            });
        } else if (options instanceof Map) {
            Map optionsMap = (Map)options;
            optionsMap.forEach((key, value) -> {
                if (!(value instanceof Map)) {
                    return;
                }
                Map optionMap = (Map)value;
                Option option = new Option();
                option.setValue(key);
                option.setLabel(optionMap.get("label").toString());
                result.add(option);
            });
        }
        return result;
    }
}

