/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.listener;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.HaloConst;
import run.halo.app.service.OptionService;
import run.halo.app.service.ThemeService;
import run.halo.app.utils.FileUtils;

@Component
@Order(value=-2147483648)
public class StartedListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(StartedListener.class);
    @Autowired
    private HaloProperties haloProperties;
    @Autowired
    private OptionService optionService;
    @Autowired
    private ThemeService themeService;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${springfox.documentation.enabled}")
    private Boolean documentationEnabled;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            this.migrate();
        }
        catch (SQLException e) {
            log.error("Failed to migrate database!", (Throwable)e);
        }
        this.initDirectory();
        this.initThemes();
        this.printStartInfo();
        this.configGit();
    }

    private void configGit() {
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowCacheConfig config = new WindowCacheConfig();
            config.setPackedGitMMAP(false);
            config.install();
        }
    }

    private void printStartInfo() {
        String blogUrl = this.optionService.getBlogBaseUrl();
        log.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_BLUE, "Halo started at         ", blogUrl}));
        log.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_BLUE, "Halo admin started at   ", blogUrl, "/", this.haloProperties.getAdminPath()}));
        if (this.documentationEnabled.booleanValue()) {
            log.debug(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_BLUE, "Halo api documentation was enabled at  ", blogUrl, "/swagger-ui.html"}));
        }
        log.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_YELLOW, "Halo has started successfully!"}));
    }

    private void migrate() throws SQLException {
        log.info("Starting migrate database...");
        Flyway flyway = Flyway.configure().locations(new String[]{"classpath:/migration"}).baselineVersion("1").baselineOnMigrate(true).dataSource(this.url, this.username, this.password).load();
        flyway.repair();
        flyway.migrate();
        Connection connection = flyway.getConfiguration().getDataSource().getConnection();
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData((Connection)connection);
        HaloConst.DATABASE_PRODUCT_NAME = databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion();
        connection.close();
        log.info("Migrate database succeed.");
    }

    private void initThemes() {
        Boolean isInstalled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.IS_INSTALLED, Boolean.class, (Object)false);
        try {
            Path source;
            String themeClassPath = "classpath:templates/themes";
            URI themeUri = ResourceUtils.getURL((String)themeClassPath).toURI();
            log.debug("Theme uri: [{}]", (Object)themeUri);
            if ("jar".equalsIgnoreCase(themeUri.getScheme())) {
                FileSystem fileSystem = this.getFileSystem(themeUri);
                source = fileSystem.getPath("/BOOT-INF/classes/templates/themes", new String[0]);
            } else {
                source = Paths.get(themeUri);
            }
            Path themePath = this.themeService.getBasePath().resolve("caicai_anatole");
            if (this.themeService.fetchThemePropertyBy("caicai_anatole").isEmpty()) {
                FileUtils.copyFolder((Path)source.resolve("anatole"), (Path)themePath);
                log.info("Copied theme folder from [{}] to [{}]", (Object)source, (Object)themePath);
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                log.error("Please check location: classpath:{}", (Object)"templates/themes");
            }
            log.error("Initialize internal theme to user path error!", (Throwable)e);
        }
    }

    @NonNull
    private FileSystem getFileSystem(@NonNull URI uri) throws IOException {
        FileSystem fileSystem;
        Assert.notNull((Object)uri, (String)"Uri must not be null");
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        return fileSystem;
    }

    private void initDirectory() {
        Path workPath = Paths.get(this.haloProperties.getWorkDir(), new String[0]);
        Path backupPath = Paths.get(this.haloProperties.getBackupDir(), new String[0]);
        Path dataExportPath = Paths.get(this.haloProperties.getDataExportDir(), new String[0]);
        try {
            if (Files.notExists(workPath, new LinkOption[0])) {
                Files.createDirectories(workPath, new FileAttribute[0]);
                log.info("Created work directory: [{}]", (Object)workPath);
            }
            if (Files.notExists(backupPath, new LinkOption[0])) {
                Files.createDirectories(backupPath, new FileAttribute[0]);
                log.info("Created backup directory: [{}]", (Object)backupPath);
            }
            if (Files.notExists(dataExportPath, new LinkOption[0])) {
                Files.createDirectories(dataExportPath, new FileAttribute[0]);
                log.info("Created data export directory: [{}]", (Object)dataExportPath);
            }
        }
        catch (IOException ie) {
            throw new RuntimeException("Failed to initialize directories", ie);
        }
    }
}

