/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.listener.comment;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import run.halo.app.event.comment.CommentNewEvent;
import run.halo.app.event.comment.CommentReplyEvent;
import run.halo.app.exception.ServiceException;
import run.halo.app.mail.MailService;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.entity.JournalComment;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.entity.User;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.JournalService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.UserService;
import run.halo.app.service.assembler.PostAssembler;
import run.halo.app.service.assembler.SheetAssembler;
import run.halo.app.utils.ValidationUtils;

@Component
public class CommentEventListener {
    private static final Logger log = LoggerFactory.getLogger(CommentEventListener.class);
    private final MailService mailService;
    private final OptionService optionService;
    private final PostCommentService postCommentService;
    private final SheetCommentService sheetCommentService;
    private final JournalCommentService journalCommentService;
    private final PostService postService;
    private final PostAssembler postAssembler;
    private final SheetService sheetService;
    private final SheetAssembler sheetAssembler;
    private final JournalService journalService;
    private final UserService userService;
    private final ThemeService themeService;

    public CommentEventListener(MailService mailService, OptionService optionService, PostCommentService postCommentService, SheetCommentService sheetCommentService, JournalCommentService journalCommentService, PostService postService, PostAssembler postAssembler, SheetService sheetService, SheetAssembler sheetAssembler, JournalService journalService, UserService userService, ThemeService themeService) {
        this.mailService = mailService;
        this.optionService = optionService;
        this.postCommentService = postCommentService;
        this.sheetCommentService = sheetCommentService;
        this.journalCommentService = journalCommentService;
        this.postService = postService;
        this.postAssembler = postAssembler;
        this.sheetService = sheetService;
        this.sheetAssembler = sheetAssembler;
        this.journalService = journalService;
        this.userService = userService;
        this.themeService = themeService;
    }

    @Async
    @EventListener
    public void handleCommentNewEvent(CommentNewEvent newEvent) {
        Boolean newCommentNotice = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.NEW_NOTICE, Boolean.class, (Object)false);
        if (!newCommentNotice.booleanValue()) {
            return;
        }
        User user = (User)this.userService.getCurrentUser().orElseThrow(() -> new ServiceException("\u672a\u67e5\u8be2\u5230\u535a\u4e3b\u4fe1\u606f"));
        HashMap<String, Object> data = new HashMap<String, Object>();
        StringBuilder subject = new StringBuilder();
        Boolean enabledAbsolutePath = this.optionService.isEnabledAbsolutePath();
        if (newEvent.getSource() instanceof PostCommentService) {
            PostComment postComment = (PostComment)this.postCommentService.getById((Object)newEvent.getCommentId());
            log.debug("Got post comment: [{}]", (Object)postComment);
            BasePostMinimalDTO post = this.postAssembler.convertToMinimal((Post)this.postService.getById((Object)postComment.getPostId()));
            data.put("pageFullPath", enabledAbsolutePath != false ? post.getFullPath() : this.optionService.getBlogBaseUrl() + post.getFullPath());
            data.put("pageTitle", post.getTitle());
            data.put("author", postComment.getAuthor());
            data.put("content", postComment.getContent());
            subject.append("\u60a8\u7684\u535a\u5ba2\u6587\u7ae0\u300a").append(post.getTitle()).append("\u300b\u6709\u4e86\u65b0\u7684\u8bc4\u8bba\u3002");
        } else if (newEvent.getSource() instanceof SheetCommentService) {
            SheetComment sheetComment = (SheetComment)this.sheetCommentService.getById((Object)newEvent.getCommentId());
            log.debug("Got sheet comment: [{}]", (Object)sheetComment);
            BasePostMinimalDTO sheet = this.sheetAssembler.convertToMinimal((Sheet)this.sheetService.getById((Object)sheetComment.getPostId()));
            data.put("pageFullPath", enabledAbsolutePath != false ? sheet.getFullPath() : this.optionService.getBlogBaseUrl() + sheet.getFullPath());
            data.put("pageTitle", sheet.getTitle());
            data.put("author", sheetComment.getAuthor());
            data.put("content", sheetComment.getContent());
            subject.append("\u60a8\u7684\u535a\u5ba2\u9875\u9762\u300a").append(sheet.getTitle()).append("\u300b\u6709\u4e86\u65b0\u7684\u8bc4\u8bba\u3002");
        } else if (newEvent.getSource() instanceof JournalCommentService) {
            JournalComment journalComment = (JournalComment)this.journalCommentService.getById((Object)newEvent.getCommentId());
            log.debug("Got journal comment: [{}]", (Object)journalComment);
            Journal journal = (Journal)this.journalService.getById((Object)journalComment.getPostId());
            StringBuilder url = new StringBuilder(this.optionService.getBlogBaseUrl()).append("/").append(this.optionService.getJournalsPrefix());
            data.put("pageFullPath", url);
            data.put("pageTitle", journal.getCreateTime());
            data.put("author", journalComment.getAuthor());
            data.put("content", journalComment.getContent());
            subject.append("\u60a8\u7684\u535a\u5ba2\u65e5\u5fd7\u6709\u4e86\u65b0\u7684\u8bc4\u8bba");
        }
        String template = "common/mail_template/mail_notice.ftl";
        if (this.themeService.templateExists("mail_template/mail_notice.ftl")) {
            template = this.themeService.renderWithSuffix("mail_template/mail_notice");
        }
        this.mailService.sendTemplateMail(user.getEmail(), subject.toString(), data, template);
    }

    @Async
    @EventListener
    public void handleCommentReplyEvent(CommentReplyEvent replyEvent) {
        Boolean replyCommentNotice = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.REPLY_NOTICE, Boolean.class, (Object)false);
        if (!replyCommentNotice.booleanValue()) {
            return;
        }
        String baseAuthorEmail = "";
        String blogTitle = this.optionService.getBlogTitle();
        HashMap<String, Object> data = new HashMap<String, Object>();
        StringBuilder subject = new StringBuilder();
        Boolean enabledAbsolutePath = this.optionService.isEnabledAbsolutePath();
        log.debug("replyEvent.getSource():" + replyEvent.getSource().toString());
        if (replyEvent.getSource() instanceof PostCommentService) {
            PostComment postComment = (PostComment)this.postCommentService.getById((Object)replyEvent.getCommentId());
            PostComment baseComment = (PostComment)this.postCommentService.getById((Object)postComment.getParentId());
            if (StringUtils.isEmpty((CharSequence)baseComment.getEmail()) && !ValidationUtils.isEmail((String)baseComment.getEmail())) {
                return;
            }
            if (!baseComment.getAllowNotification().booleanValue()) {
                return;
            }
            baseAuthorEmail = baseComment.getEmail();
            BasePostMinimalDTO post = this.postAssembler.convertToMinimal((Post)this.postService.getById((Object)postComment.getPostId()));
            data.put("pageFullPath", enabledAbsolutePath != false ? post.getFullPath() : this.optionService.getBlogBaseUrl() + post.getFullPath());
            data.put("pageTitle", post.getTitle());
            data.put("baseAuthor", baseComment.getAuthor());
            data.put("baseContent", baseComment.getContent());
            data.put("replyAuthor", postComment.getAuthor());
            data.put("replyContent", postComment.getContent());
            subject.append("\u60a8\u5728\u3010").append(blogTitle).append("\u3011\u8bc4\u8bba\u7684\u6587\u7ae0\u300a").append(post.getTitle()).append("\u300b\u6709\u4e86\u65b0\u7684\u8bc4\u8bba\u3002");
        } else if (replyEvent.getSource() instanceof SheetCommentService) {
            SheetComment sheetComment = (SheetComment)this.sheetCommentService.getById((Object)replyEvent.getCommentId());
            SheetComment baseComment = (SheetComment)this.sheetCommentService.getById((Object)sheetComment.getParentId());
            if (StringUtils.isEmpty((CharSequence)baseComment.getEmail()) && !ValidationUtils.isEmail((String)baseComment.getEmail())) {
                return;
            }
            if (!baseComment.getAllowNotification().booleanValue()) {
                return;
            }
            baseAuthorEmail = baseComment.getEmail();
            BasePostMinimalDTO sheet = this.sheetAssembler.convertToMinimal((Sheet)this.sheetService.getById((Object)sheetComment.getPostId()));
            data.put("pageFullPath", enabledAbsolutePath != false ? sheet.getFullPath() : this.optionService.getBlogBaseUrl() + sheet.getFullPath());
            data.put("pageTitle", sheet.getTitle());
            data.put("baseAuthor", baseComment.getAuthor());
            data.put("baseContent", baseComment.getContent());
            data.put("replyAuthor", sheetComment.getAuthor());
            data.put("replyContent", sheetComment.getContent());
            subject.append("\u60a8\u5728\u3010").append(blogTitle).append("\u3011\u8bc4\u8bba\u7684\u9875\u9762\u300a").append(sheet.getTitle()).append("\u300b\u6709\u4e86\u65b0\u7684\u8bc4\u8bba\u3002");
        } else if (replyEvent.getSource() instanceof JournalCommentService) {
            JournalComment journalComment = (JournalComment)this.journalCommentService.getById((Object)replyEvent.getCommentId());
            JournalComment baseComment = (JournalComment)this.journalCommentService.getById((Object)journalComment.getParentId());
            if (StringUtils.isEmpty((CharSequence)baseComment.getEmail()) && !ValidationUtils.isEmail((String)baseComment.getEmail())) {
                return;
            }
            if (!baseComment.getAllowNotification().booleanValue()) {
                return;
            }
            baseAuthorEmail = baseComment.getEmail();
            Journal journal = (Journal)this.journalService.getById((Object)journalComment.getPostId());
            StringBuilder url = new StringBuilder(this.optionService.getBlogBaseUrl()).append("/").append(this.optionService.getJournalsPrefix());
            data.put("pageFullPath", url);
            data.put("pageTitle", journal.getContent());
            data.put("baseAuthor", baseComment.getAuthor());
            data.put("baseContent", baseComment.getContent());
            data.put("replyAuthor", journalComment.getAuthor());
            data.put("replyContent", journalComment.getContent());
            subject.append("\u60a8\u5728\u3010").append(blogTitle).append("\u3011\u8bc4\u8bba\u7684\u65e5\u5fd7").append("\u6709\u4e86\u65b0\u7684\u8bc4\u8bba\u3002");
        }
        String template = "common/mail_template/mail_reply.ftl";
        if (this.themeService.templateExists("mail_template/mail_reply.ftl")) {
            template = this.themeService.renderWithSuffix("mail_template/mail_reply");
        }
        this.mailService.sendTemplateMail(baseAuthorEmail, subject.toString(), data, template);
    }
}

