/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.listener.freemarker;

import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import kr.pe.kwonnam.freemarker.inheritance.BlockDirective;
import kr.pe.kwonnam.freemarker.inheritance.PutDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.core.freemarker.inheritance.ThemeExtendsDirective;
import run.halo.app.event.options.OptionUpdatedEvent;
import run.halo.app.event.theme.ThemeActivatedEvent;
import run.halo.app.event.theme.ThemeUpdatedEvent;
import run.halo.app.event.user.UserUpdatedEvent;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.SeoProperties;
import run.halo.app.model.support.HaloConst;
import run.halo.app.service.ClientOptionService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.ThemeSettingService;
import run.halo.app.service.UserService;

@Component
public class FreemarkerConfigAwareListener {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerConfigAwareListener.class);
    private final ClientOptionService optionService;
    private final Configuration configuration;
    private final ThemeService themeService;
    private final ThemeSettingService themeSettingService;
    private final UserService userService;
    private final AbstractStringCacheStore cacheStore;

    public FreemarkerConfigAwareListener(ClientOptionService optionService, Configuration configuration, ThemeService themeService, ThemeSettingService themeSettingService, UserService userService, AbstractStringCacheStore cacheStore) throws TemplateModelException {
        this.optionService = optionService;
        this.configuration = configuration;
        this.themeService = themeService;
        this.themeSettingService = themeSettingService;
        this.userService = userService;
        this.cacheStore = cacheStore;
        this.initFreemarkerConfig();
    }

    private Map<String, TemplateModel> freemarkerLayoutDirectives() {
        HashMap<String, TemplateModel> freemarkerLayoutDirectives = new HashMap<String, TemplateModel>();
        freemarkerLayoutDirectives.put("extends", (TemplateModel)new ThemeExtendsDirective());
        freemarkerLayoutDirectives.put("block", (TemplateModel)new BlockDirective());
        freemarkerLayoutDirectives.put("put", (TemplateModel)new PutDirective());
        return freemarkerLayoutDirectives;
    }

    private void initFreemarkerConfig() throws TemplateModelException {
        this.configuration.setSharedVariable("layout", (Object)this.freemarkerLayoutDirectives());
        this.configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
    }

    @EventListener
    @Order(value=-2147483647)
    public void onApplicationStartedEvent(ApplicationStartedEvent applicationStartedEvent) throws TemplateModelException {
        log.debug("Received application started event");
        this.loadThemeConfig();
        this.loadOptionsConfig();
        this.loadUserConfig();
    }

    @EventListener
    public void onThemeActivatedEvent(ThemeActivatedEvent themeActivatedEvent) {
        log.debug("Received theme activated event");
        this.loadThemeConfig();
    }

    @EventListener
    public void onThemeUpdatedEvent(ThemeUpdatedEvent event) {
        log.debug("Received theme updated event");
        this.loadThemeConfig();
    }

    @EventListener
    public void onUserUpdate(UserUpdatedEvent event) throws TemplateModelException {
        log.debug("Received user updated event, user id: [{}]", (Object)event.getUserId());
        this.loadUserConfig();
    }

    @EventListener
    public void onOptionUpdate(OptionUpdatedEvent event) throws TemplateModelException {
        log.debug("Received option updated event");
        this.optionService.flush();
        this.cacheStore.delete((Object)"options");
        this.loadOptionsConfig();
        this.loadThemeConfig();
    }

    private void loadUserConfig() throws TemplateModelException {
        this.configuration.setSharedVariable("user", this.userService.getCurrentUser().orElse(null));
        log.debug("Loaded user");
    }

    private void loadOptionsConfig() throws TemplateModelException {
        String blogBaseUrl = this.optionService.getBlogBaseUrl();
        Object context = this.optionService.isEnabledAbsolutePath() != false ? blogBaseUrl + "/" : "/";
        this.configuration.setSharedVariable("options", (Object)this.optionService.listOptions());
        this.configuration.setSharedVariable("context", context);
        this.configuration.setSharedVariable("version", (Object)HaloConst.HALO_VERSION);
        this.configuration.setSharedVariable("globalAbsolutePathEnabled", (Object)this.optionService.isEnabledAbsolutePath());
        this.configuration.setSharedVariable("blog_title", (Object)this.optionService.getBlogTitle());
        this.configuration.setSharedVariable("blog_url", (Object)blogBaseUrl);
        this.configuration.setSharedVariable("blog_logo", this.optionService.getByPropertyOrDefault((PropertyEnum)BlogProperties.BLOG_LOGO, String.class, (Object)BlogProperties.BLOG_LOGO.defaultValue()));
        this.configuration.setSharedVariable("seo_keywords", this.optionService.getByPropertyOrDefault((PropertyEnum)SeoProperties.KEYWORDS, String.class, (Object)SeoProperties.KEYWORDS.defaultValue()));
        this.configuration.setSharedVariable("seo_description", this.optionService.getByPropertyOrDefault((PropertyEnum)SeoProperties.DESCRIPTION, String.class, (Object)SeoProperties.DESCRIPTION.defaultValue()));
        this.configuration.setSharedVariable("rss_url", (Object)(blogBaseUrl + "/rss.xml"));
        this.configuration.setSharedVariable("atom_url", (Object)(blogBaseUrl + "/atom.xml"));
        this.configuration.setSharedVariable("sitemap_xml_url", (Object)(blogBaseUrl + "/sitemap.xml"));
        this.configuration.setSharedVariable("sitemap_html_url", (Object)(blogBaseUrl + "/sitemap.html"));
        this.configuration.setSharedVariable("links_url", (Object)((String)context + this.optionService.getLinksPrefix()));
        this.configuration.setSharedVariable("photos_url", (Object)((String)context + this.optionService.getPhotosPrefix()));
        this.configuration.setSharedVariable("journals_url", (Object)((String)context + this.optionService.getJournalsPrefix()));
        this.configuration.setSharedVariable("archives_url", (Object)((String)context + this.optionService.getArchivesPrefix()));
        this.configuration.setSharedVariable("categories_url", (Object)((String)context + this.optionService.getCategoriesPrefix()));
        this.configuration.setSharedVariable("tags_url", (Object)((String)context + this.optionService.getTagsPrefix()));
        log.debug("Loaded options");
    }

    private void loadThemeConfig() {
        this.themeService.fetchActivatedTheme().ifPresent(activatedTheme -> {
            String themeBasePath = (this.optionService.isEnabledAbsolutePath() != false ? this.optionService.getBlogBaseUrl() : "") + "/themes/" + activatedTheme.getFolderName();
            try {
                this.configuration.setSharedVariable("theme", activatedTheme);
                this.configuration.setSharedVariable("static", (Object)themeBasePath);
                this.configuration.setSharedVariable("theme_base", (Object)themeBasePath);
                this.configuration.setSharedVariable("settings", (Object)this.themeSettingService.listAsMapBy(this.themeService.getActivatedThemeId()));
                log.debug("Loaded theme and settings");
            }
            catch (TemplateModelException e) {
                log.error("Failed to set shared variable!", (Throwable)e);
            }
        });
    }
}

