/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.listener.post;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import run.halo.app.event.post.AbstractVisitEvent;
import run.halo.app.listener.post.AbstractVisitEventListener;
import run.halo.app.service.base.BasePostService;

public abstract class AbstractVisitEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractVisitEventListener.class);
    private final Map<Integer, BlockingQueue<Integer>> visitQueueMap;
    private final Map<Integer, PostVisitTask> visitTaskMap;
    private final BasePostService basePostService;
    private final ExecutorService executor;

    protected AbstractVisitEventListener(BasePostService basePostService) {
        this.basePostService = basePostService;
        int initCapacity = 8;
        long count = basePostService.count();
        if (count < (long)initCapacity) {
            initCapacity = (int)count;
        }
        this.visitQueueMap = new ConcurrentHashMap(initCapacity << 1);
        this.visitTaskMap = new ConcurrentHashMap(initCapacity << 1);
        this.executor = Executors.newCachedThreadPool();
    }

    protected void handleVisitEvent(@NonNull AbstractVisitEvent event) throws InterruptedException {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Assert.notNull((Object)event, (String)"Visit event must not be null");
        Integer id = event.getId();
        log.debug("Received a visit event, post id: [{}]", (Object)id);
        BlockingQueue postVisitQueue = this.visitQueueMap.computeIfAbsent(id, arg_0 -> this.createEmptyQueue(arg_0));
        this.visitTaskMap.computeIfAbsent(id, arg_0 -> this.createPostVisitTask(arg_0));
        postVisitQueue.put(id);
    }

    private PostVisitTask createPostVisitTask(Integer postId) {
        PostVisitTask postVisitTask = new PostVisitTask(this, postId);
        this.executor.execute((Runnable)postVisitTask);
        log.debug("Created a new post visit task for post id: [{}]", (Object)postId);
        return postVisitTask;
    }

    private BlockingQueue<Integer> createEmptyQueue(Integer postId) {
        return new LinkedBlockingQueue<Integer>();
    }
}

