/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.listener.post;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import run.halo.app.event.category.CategoryUpdatedEvent;
import run.halo.app.event.post.PostUpdatedEvent;
import run.halo.app.listener.post.PostRefreshStatusListener;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostService;

@Component
public class PostRefreshStatusListener {
    private final PostService postService;
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;

    public PostRefreshStatusListener(PostService postService, CategoryService categoryService, PostCategoryService postCategoryService) {
        this.postService = postService;
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
    }

    @EventListener(value={CategoryUpdatedEvent.class})
    public void categoryUpdatedListener(CategoryUpdatedEvent event) {
        Category category = event.getCategory();
        Category beforeUpdated = event.getBeforeUpdated();
        boolean beforeIsPrivate = event.isBeforeIsPrivate();
        RecordState recordState = this.determineRecordState(beforeUpdated, category);
        List posts = this.postService.listAllByIds((Collection)event.getPostIds());
        if (RecordState.DELETED.equals((Object)recordState) || category == null) {
            if (beforeUpdated == null || !beforeIsPrivate) {
                return;
            }
            this.changeStatusToPublishIfNecessary(posts, beforeUpdated.getId());
            return;
        }
        boolean isPrivate = this.categoryService.isPrivate(category.getId());
        if (isPrivate) {
            ArrayList postsToUpdate = new ArrayList();
            posts.forEach(post -> {
                if (post.getStatus() == PostStatus.PUBLISHED) {
                    post.setStatus(PostStatus.INTIMATE);
                    postsToUpdate.add(post);
                }
            });
            this.postService.updateInBatch(postsToUpdate);
        } else if (beforeIsPrivate && RecordState.UPDATED.equals((Object)recordState)) {
            this.changeStatusToPublishIfNecessary(posts, category.getId());
        }
    }

    private void changeStatusToPublishIfNecessary(List<Post> posts, Integer categoryId) {
        ArrayList<Post> postsToUpdate = new ArrayList<Post>();
        for (Post post : posts) {
            boolean belongsToEncryptedCategory = this.postBelongsToEncryptedCategory(post.getId());
            if (belongsToEncryptedCategory || !StringUtils.isBlank((CharSequence)post.getPassword()) || post.getStatus() != PostStatus.INTIMATE) continue;
            post.setStatus(PostStatus.PUBLISHED);
            postsToUpdate.add(post);
        }
        this.postService.updateInBatch(postsToUpdate);
    }

    private boolean postBelongsToEncryptedCategory(Integer postId) {
        Set categoryIds = this.postCategoryService.listCategoryIdsByPostId(postId);
        boolean encrypted = false;
        for (Integer categoryId : categoryIds) {
            if (!this.categoryService.isPrivate(categoryId)) continue;
            encrypted = true;
            break;
        }
        return encrypted;
    }

    private RecordState determineRecordState(Category before, Category updated) {
        if (before == null) {
            if (updated != null) {
                return RecordState.CREATED;
            }
            return RecordState.UNCHANGED;
        }
        if (updated == null) {
            return RecordState.DELETED;
        }
        return RecordState.UPDATED;
    }

    @EventListener(value={PostUpdatedEvent.class})
    public void postUpdatedListener(PostUpdatedEvent event) {
        Post post = event.getPost();
        if (!this.postService.existsById((Object)post.getId())) {
            return;
        }
        PostStatus status = post.getStatus();
        if (PostStatus.RECYCLE.equals((Object)status)) {
            return;
        }
        boolean isPrivate = this.postCategoryService.listByPostId(post.getId()).stream().anyMatch(postCategory -> this.categoryService.isPrivate(postCategory.getCategoryId()));
        if (post.getStatus() != PostStatus.DRAFT) {
            status = isPrivate || StringUtils.isNotEmpty((CharSequence)post.getPassword()) ? PostStatus.INTIMATE : PostStatus.PUBLISHED;
        } else if (!isPrivate && StringUtils.isBlank((CharSequence)post.getPassword())) {
            status = PostStatus.DRAFT;
        }
        post.setStatus(status);
        this.postService.update((Object)post);
    }
}

