/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.mail;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;
import run.halo.app.exception.EmailException;
import run.halo.app.mail.MailProperties;
import run.halo.app.mail.MailSenderFactory;
import run.halo.app.mail.MailService;
import run.halo.app.model.properties.EmailProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.OptionService;

public abstract class AbstractMailService
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(AbstractMailService.class);
    private static final int DEFAULT_POOL_SIZE = 5;
    protected final OptionService optionService;
    private JavaMailSender cachedMailSender;
    private MailProperties cachedMailProperties;
    private String cachedFromName;
    @Nullable
    private ExecutorService executorService;

    protected AbstractMailService(OptionService optionService) {
        this.optionService = optionService;
    }

    @NonNull
    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(5);
        }
        return this.executorService;
    }

    public void setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void testConnection() {
        JavaMailSender javaMailSender = this.getMailSender();
        if (javaMailSender instanceof JavaMailSenderImpl) {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)javaMailSender;
            try {
                mailSender.testConnection();
            }
            catch (MessagingException e) {
                throw new EmailException("\u65e0\u6cd5\u8fde\u63a5\u5230\u90ae\u7bb1\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u90ae\u7bb1\u914d\u7f6e.[" + e.getMessage() + "]", (Throwable)e);
            }
        }
    }

    protected void sendMailTemplate(@Nullable Consumer<MimeMessageHelper> callback) {
        if (callback == null) {
            log.info("Callback is null, skip to send email");
            return;
        }
        Boolean emailEnabled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.ENABLED, Boolean.class);
        if (!emailEnabled.booleanValue()) {
            log.info("Email has been disabled by yourself, you can re-enable it through email settings on admin page.");
            return;
        }
        JavaMailSender mailSender = this.getMailSender();
        this.printMailConfig();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mailSender.createMimeMessage());
        try {
            messageHelper.setFrom(this.getFromAddress(mailSender));
            callback.accept(messageHelper);
            MimeMessage mimeMessage = messageHelper.getMimeMessage();
            mailSender.send(mimeMessage);
            log.info("Sent an email to [{}] successfully, subject: [{}], sent date: [{}]", new Object[]{Arrays.toString(mimeMessage.getAllRecipients()), mimeMessage.getSubject(), mimeMessage.getSentDate()});
        }
        catch (Exception e) {
            throw new EmailException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 SMTP \u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u786e", (Throwable)e);
        }
    }

    protected void sendMailTemplate(boolean tryToAsync, @Nullable Consumer<MimeMessageHelper> callback) {
        ExecutorService executorService = this.getExecutorService();
        if (tryToAsync) {
            executorService.execute(() -> this.sendMailTemplate(callback));
        } else {
            this.sendMailTemplate(callback);
        }
    }

    @NonNull
    private synchronized JavaMailSender getMailSender() {
        if (this.cachedMailSender == null) {
            MailSenderFactory mailSenderFactory = new MailSenderFactory();
            this.cachedMailSender = mailSenderFactory.getMailSender((org.springframework.boot.autoconfigure.mail.MailProperties)this.getMailProperties());
        }
        return this.cachedMailSender;
    }

    private synchronized InternetAddress getFromAddress(@NonNull JavaMailSender javaMailSender) throws UnsupportedEncodingException {
        Assert.notNull((Object)javaMailSender, (String)"Java mail sender must not be null");
        if (StringUtils.isBlank((CharSequence)this.cachedFromName)) {
            this.cachedFromName = this.optionService.getByPropertyOfNonNull((PropertyEnum)EmailProperties.FROM_NAME).toString();
        }
        if (javaMailSender instanceof JavaMailSenderImpl) {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)javaMailSender;
            String username = mailSender.getUsername();
            return new InternetAddress(username, this.cachedFromName, mailSender.getDefaultEncoding());
        }
        throw new UnsupportedOperationException("Unsupported java mail sender: " + javaMailSender.getClass().getName());
    }

    @NonNull
    private synchronized MailProperties getMailProperties() {
        if (this.cachedMailProperties == null) {
            MailProperties mailProperties = new MailProperties(log.isDebugEnabled());
            mailProperties.setHost((String)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.HOST, String.class));
            mailProperties.setPort((Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.SSL_PORT, Integer.class));
            mailProperties.setUsername((String)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.USERNAME, String.class));
            mailProperties.setPassword((String)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.PASSWORD, String.class));
            mailProperties.setProtocol((String)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.PROTOCOL, String.class));
            this.cachedMailProperties = mailProperties;
        }
        return this.cachedMailProperties;
    }

    private void printMailConfig() {
        if (!log.isDebugEnabled()) {
            return;
        }
        MailProperties mailProperties = this.getMailProperties();
        log.debug(mailProperties.toString());
    }

    protected void clearCache() {
        this.cachedMailSender = null;
        this.cachedFromName = null;
        this.cachedMailProperties = null;
        log.debug("Cleared all mail caches");
    }
}

