/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.mail;

import java.util.Map;
import java.util.Properties;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.lang.NonNull;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MailSenderFactory {
    @NonNull
    public JavaMailSender getMailSender(@NonNull MailProperties mailProperties) {
        Assert.notNull((Object)mailProperties, (String)"Mail properties must not be null");
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        this.setProperties(mailSender, mailProperties);
        return mailSender;
    }

    private void setProperties(@NonNull JavaMailSenderImpl mailSender, @NonNull MailProperties mailProperties) {
        mailSender.setHost(mailProperties.getHost());
        mailSender.setPort(mailProperties.getPort().intValue());
        mailSender.setUsername(mailProperties.getUsername());
        mailSender.setPassword(mailProperties.getPassword());
        mailSender.setProtocol(mailProperties.getProtocol());
        mailSender.setDefaultEncoding(mailProperties.getDefaultEncoding().name());
        if (!CollectionUtils.isEmpty((Map)mailProperties.getProperties())) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)mailProperties.getProperties());
            mailSender.setJavaMailProperties(properties);
        }
    }
}

