/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import run.halo.app.event.options.OptionUpdatedEvent;
import run.halo.app.mail.AbstractMailService;
import run.halo.app.service.OptionService;

@Service
public class MailServiceImpl
extends AbstractMailService
implements ApplicationListener<OptionUpdatedEvent> {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    private final FreeMarkerConfigurer freeMarker;

    public MailServiceImpl(FreeMarkerConfigurer freeMarker, OptionService optionService) {
        super(optionService);
        this.freeMarker = freeMarker;
    }

    public void sendTextMail(String to, String subject, String content) {
        this.sendMailTemplate(true, messageHelper -> {
            try {
                messageHelper.setSubject(subject);
                messageHelper.setTo(to);
                messageHelper.setText(content);
            }
            catch (MessagingException e) {
                throw new RuntimeException("Failed to set message subject, to or test!", e);
            }
        });
    }

    public void sendTemplateMail(String to, String subject, Map<String, Object> content, String templateName) {
        this.sendMailTemplate(true, messageHelper -> {
            try {
                Template template = this.freeMarker.getConfiguration().getTemplate(templateName);
                String contentResult = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)content);
                messageHelper.setSubject(subject);
                messageHelper.setTo(to);
                messageHelper.setText(contentResult, true);
            }
            catch (TemplateException | IOException e) {
                throw new RuntimeException("Failed to convert template to html!", e);
            }
            catch (MessagingException e) {
                throw new RuntimeException("Failed to set message subject, to or test", e);
            }
        });
    }

    public void sendAttachMail(String to, String subject, Map<String, Object> content, String templateName, String attachFilePath) {
        this.sendMailTemplate(true, messageHelper -> {
            try {
                messageHelper.setSubject(subject);
                messageHelper.setTo(to);
                Path attachmentPath = Paths.get(attachFilePath, new String[0]);
                messageHelper.addAttachment(attachmentPath.getFileName().toString(), attachmentPath.toFile());
            }
            catch (MessagingException e) {
                throw new RuntimeException("Failed to set message subject, to or test", e);
            }
        });
    }

    public void testConnection() {
        super.testConnection();
    }

    public void onApplicationEvent(@NonNull OptionUpdatedEvent event) {
        this.clearCache();
    }
}

