/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.dto.base;

import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.springframework.lang.Nullable;
import run.halo.app.utils.BeanUtils;
import run.halo.app.utils.ReflectionUtils;

public interface InputConverter<D> {
    default public D convertTo() {
        ParameterizedType currentType = this.parameterizedType();
        Objects.requireNonNull(currentType, "Cannot fetch actual type because parameterized type is null");
        Class domainClass = (Class)currentType.getActualTypeArguments()[0];
        return (D)BeanUtils.transformFrom((Object)this, (Class)domainClass);
    }

    default public void update(D domain) {
        BeanUtils.updateProperties((Object)this, domain);
    }

    @Nullable
    default public ParameterizedType parameterizedType() {
        return ReflectionUtils.getParameterizedType(InputConverter.class, this.getClass());
    }
}

