/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.dto.post;

import org.springframework.lang.NonNull;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;

public class BasePostDetailDTO
extends BasePostSimpleDTO {
    private String originalContent;
    private String content;
    private Long commentCount;

    @NonNull
    public <T extends BasePostMinimalDTO> T convertFrom(@NonNull BasePost domain) {
        BasePostDetailDTO postDetailDTO = (BasePostDetailDTO)super.convertFrom((Object)domain);
        Content.PatchedContent content = domain.getContent();
        postDetailDTO.setContent(content.getContent());
        postDetailDTO.setOriginalContent(content.getOriginalContent());
        return (T)postDetailDTO;
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    public String getFormatContent() {
        return this.content;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public String getContent() {
        return this.content;
    }

    public Long getCommentCount() {
        return this.commentCount;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public String toString() {
        return "BasePostDetailDTO(originalContent=" + this.getOriginalContent() + ", content=" + this.getContent() + ", commentCount=" + this.getCommentCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePostDetailDTO)) {
            return false;
        }
        BasePostDetailDTO other = (BasePostDetailDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$commentCount = this.getCommentCount();
        Long other$commentCount = other.getCommentCount();
        if (this$commentCount == null ? other$commentCount != null : !((Object)this$commentCount).equals(other$commentCount)) {
            return false;
        }
        String this$originalContent = this.getOriginalContent();
        String other$originalContent = other.getOriginalContent();
        if (this$originalContent == null ? other$originalContent != null : !this$originalContent.equals(other$originalContent)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePostDetailDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $commentCount = this.getCommentCount();
        result = result * 59 + ($commentCount == null ? 43 : ((Object)$commentCount).hashCode());
        String $originalContent = this.getOriginalContent();
        result = result * 59 + ($originalContent == null ? 43 : $originalContent.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

