/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.AttachmentType;

@Entity
@Table(name="attachments", indexes={@Index(name="attachments_media_type", columnList="media_type"), @Index(name="attachments_create_time", columnList="create_time")})
public class Attachment
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="path", length=1023, nullable=false)
    private String path;
    @Column(name="file_key", length=2047)
    private String fileKey;
    @Column(name="thumb_path", length=1023)
    private String thumbPath;
    @Column(name="media_type", length=127, nullable=false)
    private String mediaType;
    @Column(name="suffix", length=50)
    private String suffix;
    @Column(name="width")
    @ColumnDefault(value="0")
    private Integer width;
    @Column(name="height")
    @ColumnDefault(value="0")
    private Integer height;
    @Column(name="size", nullable=false)
    private Long size;
    @Column(name="type")
    @ColumnDefault(value="0")
    private AttachmentType type;

    public void prePersist() {
        super.prePersist();
        if (this.fileKey == null) {
            this.fileKey = "";
        }
        if (this.thumbPath == null) {
            this.thumbPath = "";
        }
        if (this.suffix == null) {
            this.suffix = "";
        }
        if (this.width == null) {
            this.width = 0;
        }
        if (this.height == null) {
            this.height = 0;
        }
        if (this.type == null) {
            this.type = AttachmentType.LOCAL;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public String getThumbPath() {
        return this.thumbPath;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Long getSize() {
        return this.size;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public void setThumbPath(String thumbPath) {
        this.thumbPath = thumbPath;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setType(AttachmentType type) {
        this.type = type;
    }

    public String toString() {
        return "Attachment(id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", fileKey=" + this.getFileKey() + ", thumbPath=" + this.getThumbPath() + ", mediaType=" + this.getMediaType() + ", suffix=" + this.getSuffix() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", size=" + this.getSize() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$fileKey = this.getFileKey();
        String other$fileKey = other.getFileKey();
        if (this$fileKey == null ? other$fileKey != null : !this$fileKey.equals(other$fileKey)) {
            return false;
        }
        String this$thumbPath = this.getThumbPath();
        String other$thumbPath = other.getThumbPath();
        if (this$thumbPath == null ? other$thumbPath != null : !this$thumbPath.equals(other$thumbPath)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        AttachmentType this$type = this.getType();
        AttachmentType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $fileKey = this.getFileKey();
        result = result * 59 + ($fileKey == null ? 43 : $fileKey.hashCode());
        String $thumbPath = this.getThumbPath();
        result = result * 59 + ($thumbPath == null ? 43 : $thumbPath.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        AttachmentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

