/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.utils.ServiceUtils;

@Entity(name="BaseComment")
@Table(name="comments", indexes={@Index(name="comments_post_id", columnList="post_id"), @Index(name="comments_type_status", columnList="type, status"), @Index(name="comments_parent_id", columnList="parent_id")})
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.INTEGER, columnDefinition="int default 0")
public class BaseComment
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Long id;
    @Column(name="author", length=50, nullable=false)
    private String author;
    @Column(name="email")
    private String email;
    @Column(name="ip_address", length=127)
    private String ipAddress;
    @Column(name="author_url", length=511)
    private String authorUrl;
    @Column(name="gravatar_md5", length=127)
    private String gravatarMd5;
    @Column(name="content", length=1023, nullable=false)
    private String content;
    @Column(name="status")
    @ColumnDefault(value="1")
    private CommentStatus status;
    @Column(name="user_agent", length=511)
    private String userAgent;
    @Column(name="is_admin")
    @ColumnDefault(value="0")
    private Boolean isAdmin;
    @Column(name="allow_notification")
    @ColumnDefault(value="1")
    private Boolean allowNotification;
    @Column(name="post_id", nullable=false)
    private Integer postId;
    @Column(name="top_priority")
    @ColumnDefault(value="0")
    private Integer topPriority;
    @Column(name="parent_id")
    @ColumnDefault(value="0")
    private Long parentId;

    public void prePersist() {
        super.prePersist();
        if (ServiceUtils.isEmptyId((Number)this.parentId)) {
            this.parentId = 0L;
        }
        if (this.ipAddress == null) {
            this.ipAddress = "";
        }
        if (this.authorUrl == null) {
            this.authorUrl = "";
        }
        if (this.gravatarMd5 == null) {
            this.gravatarMd5 = "";
        }
        if (this.status == null) {
            this.status = CommentStatus.AUDITING;
        }
        if (this.userAgent == null) {
            this.userAgent = "";
        }
        if (this.isAdmin == null) {
            this.isAdmin = false;
        }
        if (this.allowNotification == null) {
            this.allowNotification = true;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getEmail() {
        return this.email;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public String getGravatarMd5() {
        return this.gravatarMd5;
    }

    public String getContent() {
        return this.content;
    }

    public CommentStatus getStatus() {
        return this.status;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public Boolean getAllowNotification() {
        return this.allowNotification;
    }

    public Integer getPostId() {
        return this.postId;
    }

    public Integer getTopPriority() {
        return this.topPriority;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
    }

    public void setGravatarMd5(String gravatarMd5) {
        this.gravatarMd5 = gravatarMd5;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setStatus(CommentStatus status) {
        this.status = status;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setAllowNotification(Boolean allowNotification) {
        this.allowNotification = allowNotification;
    }

    public void setPostId(Integer postId) {
        this.postId = postId;
    }

    public void setTopPriority(Integer topPriority) {
        this.topPriority = topPriority;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return "BaseComment(super=" + super.toString() + ", id=" + this.getId() + ", author=" + this.getAuthor() + ", email=" + this.getEmail() + ", ipAddress=" + this.getIpAddress() + ", authorUrl=" + this.getAuthorUrl() + ", gravatarMd5=" + this.getGravatarMd5() + ", content=" + this.getContent() + ", status=" + this.getStatus() + ", userAgent=" + this.getUserAgent() + ", isAdmin=" + this.getIsAdmin() + ", allowNotification=" + this.getAllowNotification() + ", postId=" + this.getPostId() + ", topPriority=" + this.getTopPriority() + ", parentId=" + this.getParentId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseComment)) {
            return false;
        }
        BaseComment other = (BaseComment)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$isAdmin = this.getIsAdmin();
        Boolean other$isAdmin = other.getIsAdmin();
        if (this$isAdmin == null ? other$isAdmin != null : !((Object)this$isAdmin).equals(other$isAdmin)) {
            return false;
        }
        Boolean this$allowNotification = this.getAllowNotification();
        Boolean other$allowNotification = other.getAllowNotification();
        if (this$allowNotification == null ? other$allowNotification != null : !((Object)this$allowNotification).equals(other$allowNotification)) {
            return false;
        }
        Integer this$postId = this.getPostId();
        Integer other$postId = other.getPostId();
        if (this$postId == null ? other$postId != null : !((Object)this$postId).equals(other$postId)) {
            return false;
        }
        Integer this$topPriority = this.getTopPriority();
        Integer other$topPriority = other.getTopPriority();
        if (this$topPriority == null ? other$topPriority != null : !((Object)this$topPriority).equals(other$topPriority)) {
            return false;
        }
        Long this$parentId = this.getParentId();
        Long other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$authorUrl = this.getAuthorUrl();
        String other$authorUrl = other.getAuthorUrl();
        if (this$authorUrl == null ? other$authorUrl != null : !this$authorUrl.equals(other$authorUrl)) {
            return false;
        }
        String this$gravatarMd5 = this.getGravatarMd5();
        String other$gravatarMd5 = other.getGravatarMd5();
        if (this$gravatarMd5 == null ? other$gravatarMd5 != null : !this$gravatarMd5.equals(other$gravatarMd5)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        CommentStatus this$status = this.getStatus();
        CommentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseComment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $isAdmin = this.getIsAdmin();
        result = result * 59 + ($isAdmin == null ? 43 : ((Object)$isAdmin).hashCode());
        Boolean $allowNotification = this.getAllowNotification();
        result = result * 59 + ($allowNotification == null ? 43 : ((Object)$allowNotification).hashCode());
        Integer $postId = this.getPostId();
        result = result * 59 + ($postId == null ? 43 : ((Object)$postId).hashCode());
        Integer $topPriority = this.getTopPriority();
        result = result * 59 + ($topPriority == null ? 43 : ((Object)$topPriority).hashCode());
        Long $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $authorUrl = this.getAuthorUrl();
        result = result * 59 + ($authorUrl == null ? 43 : $authorUrl.hashCode());
        String $gravatarMd5 = this.getGravatarMd5();
        result = result * 59 + ($gravatarMd5 == null ? 43 : $gravatarMd5.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        CommentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
    }
}

