/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.entity.Content;
import run.halo.app.model.enums.PostEditorType;
import run.halo.app.model.enums.PostStatus;

@Entity(name="BasePost")
@Table(name="posts", indexes={@Index(name="posts_type_status", columnList="type, status"), @Index(name="posts_create_time", columnList="create_time")})
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.INTEGER, columnDefinition="int default 0")
public class BasePost
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="title", nullable=false)
    private String title;
    @Column(name="status")
    @ColumnDefault(value="1")
    private PostStatus status;
    @Deprecated
    @Column(name="url")
    private String url;
    @Column(name="slug", unique=true)
    private String slug;
    @Column(name="editor_type")
    @ColumnDefault(value="0")
    private PostEditorType editorType;
    @Column(name="original_content")
    @Lob
    private String originalContent;
    @Column(name="format_content")
    @Lob
    private String formatContent;
    @Column(name="summary")
    @Lob
    private String summary;
    @Column(name="thumbnail", length=1023)
    private String thumbnail;
    @Column(name="visits")
    @ColumnDefault(value="0")
    private Long visits;
    @Column(name="disallow_comment")
    @ColumnDefault(value="0")
    private Boolean disallowComment;
    @Column(name="password")
    private String password;
    @Column(name="template")
    private String template;
    @Column(name="top_priority")
    @ColumnDefault(value="0")
    private Integer topPriority;
    @Column(name="likes")
    @ColumnDefault(value="0")
    private Long likes;
    @Column(name="edit_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date editTime;
    @Column(name="meta_keywords", length=511)
    private String metaKeywords;
    @Column(name="meta_description", length=1023)
    private String metaDescription;
    @Column(name="word_count")
    @ColumnDefault(value="0")
    private Long wordCount;
    @ColumnDefault(value="1")
    private Integer version;
    @Transient
    private Content.PatchedContent content;

    public void prePersist() {
        super.prePersist();
        if (this.editTime == null) {
            this.editTime = this.getCreateTime();
        }
        if (this.status == null) {
            this.status = PostStatus.DRAFT;
        }
        if (this.summary == null) {
            this.summary = "";
        }
        if (this.thumbnail == null) {
            this.thumbnail = "";
        }
        if (this.disallowComment == null) {
            this.disallowComment = false;
        }
        if (this.password == null) {
            this.password = "";
        }
        if (this.template == null) {
            this.template = "";
        }
        if (this.topPriority == null) {
            this.topPriority = 0;
        }
        if (this.visits == null || this.visits < 0L) {
            this.visits = 0L;
        }
        if (this.likes == null || this.likes < 0L) {
            this.likes = 0L;
        }
        if (this.editorType == null) {
            this.editorType = PostEditorType.MARKDOWN;
        }
        if (this.wordCount == null || this.wordCount < 0L) {
            this.wordCount = 0L;
        }
        if (this.version == null || this.version < 0) {
            this.version = 1;
        }
        this.originalContent = "";
        this.formatContent = "";
    }

    protected void preUpdate() {
        super.preUpdate();
        this.originalContent = "";
        this.formatContent = "";
    }

    @NonNull
    public Content.PatchedContent getContent() {
        if (this.content == null) {
            Content.PatchedContent patchedContent = new Content.PatchedContent();
            patchedContent.setOriginalContent("");
            patchedContent.setContent("");
            return patchedContent;
        }
        return this.content;
    }

    @Nullable
    public Content.PatchedContent getContentOfNullable() {
        return this.content;
    }

    public Integer getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public PostStatus getStatus() {
        return this.status;
    }

    @Deprecated
    public String getUrl() {
        return this.url;
    }

    public String getSlug() {
        return this.slug;
    }

    public PostEditorType getEditorType() {
        return this.editorType;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public String getFormatContent() {
        return this.formatContent;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public Long getVisits() {
        return this.visits;
    }

    public Boolean getDisallowComment() {
        return this.disallowComment;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTemplate() {
        return this.template;
    }

    public Integer getTopPriority() {
        return this.topPriority;
    }

    public Long getLikes() {
        return this.likes;
    }

    public Date getEditTime() {
        return this.editTime;
    }

    public String getMetaKeywords() {
        return this.metaKeywords;
    }

    public String getMetaDescription() {
        return this.metaDescription;
    }

    public Long getWordCount() {
        return this.wordCount;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStatus(PostStatus status) {
        this.status = status;
    }

    @Deprecated
    public void setUrl(String url) {
        this.url = url;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setEditorType(PostEditorType editorType) {
        this.editorType = editorType;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public void setFormatContent(String formatContent) {
        this.formatContent = formatContent;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setVisits(Long visits) {
        this.visits = visits;
    }

    public void setDisallowComment(Boolean disallowComment) {
        this.disallowComment = disallowComment;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setTopPriority(Integer topPriority) {
        this.topPriority = topPriority;
    }

    public void setLikes(Long likes) {
        this.likes = likes;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    public void setMetaKeywords(String metaKeywords) {
        this.metaKeywords = metaKeywords;
    }

    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public void setWordCount(Long wordCount) {
        this.wordCount = wordCount;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setContent(Content.PatchedContent content) {
        this.content = content;
    }

    public String toString() {
        return "BasePost(super=" + super.toString() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", status=" + this.getStatus() + ", url=" + this.getUrl() + ", slug=" + this.getSlug() + ", editorType=" + this.getEditorType() + ", originalContent=" + this.getOriginalContent() + ", formatContent=" + this.getFormatContent() + ", summary=" + this.getSummary() + ", thumbnail=" + this.getThumbnail() + ", visits=" + this.getVisits() + ", disallowComment=" + this.getDisallowComment() + ", password=" + this.getPassword() + ", template=" + this.getTemplate() + ", topPriority=" + this.getTopPriority() + ", likes=" + this.getLikes() + ", editTime=" + this.getEditTime() + ", metaKeywords=" + this.getMetaKeywords() + ", metaDescription=" + this.getMetaDescription() + ", wordCount=" + this.getWordCount() + ", version=" + this.getVersion() + ", content=" + this.getContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePost)) {
            return false;
        }
        BasePost other = (BasePost)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$visits = this.getVisits();
        Long other$visits = other.getVisits();
        if (this$visits == null ? other$visits != null : !((Object)this$visits).equals(other$visits)) {
            return false;
        }
        Boolean this$disallowComment = this.getDisallowComment();
        Boolean other$disallowComment = other.getDisallowComment();
        if (this$disallowComment == null ? other$disallowComment != null : !((Object)this$disallowComment).equals(other$disallowComment)) {
            return false;
        }
        Integer this$topPriority = this.getTopPriority();
        Integer other$topPriority = other.getTopPriority();
        if (this$topPriority == null ? other$topPriority != null : !((Object)this$topPriority).equals(other$topPriority)) {
            return false;
        }
        Long this$likes = this.getLikes();
        Long other$likes = other.getLikes();
        if (this$likes == null ? other$likes != null : !((Object)this$likes).equals(other$likes)) {
            return false;
        }
        Long this$wordCount = this.getWordCount();
        Long other$wordCount = other.getWordCount();
        if (this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        PostStatus this$status = this.getStatus();
        PostStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        PostEditorType this$editorType = this.getEditorType();
        PostEditorType other$editorType = other.getEditorType();
        if (this$editorType == null ? other$editorType != null : !this$editorType.equals(other$editorType)) {
            return false;
        }
        String this$originalContent = this.getOriginalContent();
        String other$originalContent = other.getOriginalContent();
        if (this$originalContent == null ? other$originalContent != null : !this$originalContent.equals(other$originalContent)) {
            return false;
        }
        String this$formatContent = this.getFormatContent();
        String other$formatContent = other.getFormatContent();
        if (this$formatContent == null ? other$formatContent != null : !this$formatContent.equals(other$formatContent)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Date this$editTime = this.getEditTime();
        Date other$editTime = other.getEditTime();
        if (this$editTime == null ? other$editTime != null : !((Object)this$editTime).equals(other$editTime)) {
            return false;
        }
        String this$metaKeywords = this.getMetaKeywords();
        String other$metaKeywords = other.getMetaKeywords();
        if (this$metaKeywords == null ? other$metaKeywords != null : !this$metaKeywords.equals(other$metaKeywords)) {
            return false;
        }
        String this$metaDescription = this.getMetaDescription();
        String other$metaDescription = other.getMetaDescription();
        if (this$metaDescription == null ? other$metaDescription != null : !this$metaDescription.equals(other$metaDescription)) {
            return false;
        }
        Content.PatchedContent this$content = this.getContent();
        Content.PatchedContent other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePost;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $visits = this.getVisits();
        result = result * 59 + ($visits == null ? 43 : ((Object)$visits).hashCode());
        Boolean $disallowComment = this.getDisallowComment();
        result = result * 59 + ($disallowComment == null ? 43 : ((Object)$disallowComment).hashCode());
        Integer $topPriority = this.getTopPriority();
        result = result * 59 + ($topPriority == null ? 43 : ((Object)$topPriority).hashCode());
        Long $likes = this.getLikes();
        result = result * 59 + ($likes == null ? 43 : ((Object)$likes).hashCode());
        Long $wordCount = this.getWordCount();
        result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        PostStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        PostEditorType $editorType = this.getEditorType();
        result = result * 59 + ($editorType == null ? 43 : $editorType.hashCode());
        String $originalContent = this.getOriginalContent();
        result = result * 59 + ($originalContent == null ? 43 : $originalContent.hashCode());
        String $formatContent = this.getFormatContent();
        result = result * 59 + ($formatContent == null ? 43 : $formatContent.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Date $editTime = this.getEditTime();
        result = result * 59 + ($editTime == null ? 43 : ((Object)$editTime).hashCode());
        String $metaKeywords = this.getMetaKeywords();
        result = result * 59 + ($metaKeywords == null ? 43 : $metaKeywords.hashCode());
        String $metaDescription = this.getMetaDescription();
        result = result * 59 + ($metaDescription == null ? 43 : $metaDescription.hashCode());
        Content.PatchedContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

