/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;

@Entity
@Table(name="categories", indexes={@Index(name="categories_name", columnList="name"), @Index(name="categories_parent_id", columnList="parent_id")})
public class Category
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="name", nullable=false)
    private String name;
    @Deprecated
    @Column(name="slug_name")
    private String slugName;
    @Column(name="slug", unique=true)
    private String slug;
    @Column(name="description", length=100)
    private String description;
    @Column(name="thumbnail", length=1023)
    private String thumbnail;
    @Column(name="parent_id")
    @ColumnDefault(value="0")
    private Integer parentId;
    @Column(name="priority")
    @ColumnDefault(value="0")
    private Integer priority;
    @Column(name="password")
    private String password;

    public void prePersist() {
        super.prePersist();
        if (this.description == null) {
            this.description = "";
        }
        if (this.parentId == null || this.parentId < 0) {
            this.parentId = 0;
        }
        if (this.priority == null) {
            this.priority = 0;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getSlugName() {
        return this.slugName;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getPassword() {
        return this.password;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public void setSlugName(String slugName) {
        this.slugName = slugName;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "Category(id=" + this.getId() + ", name=" + this.getName() + ", slugName=" + this.getSlugName() + ", slug=" + this.getSlug() + ", description=" + this.getDescription() + ", thumbnail=" + this.getThumbnail() + ", parentId=" + this.getParentId() + ", priority=" + this.getPriority() + ", password=" + this.getPassword() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Category)) {
            return false;
        }
        Category other = (Category)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$slugName = this.getSlugName();
        String other$slugName = other.getSlugName();
        if (this$slugName == null ? other$slugName != null : !this$slugName.equals(other$slugName)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Category;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $slugName = this.getSlugName();
        result = result * 59 + ($slugName == null ? 43 : $slugName.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

