/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.PostStatus;

@Entity
@Table(name="contents")
public class Content
extends BaseEntity {
    @Id
    @Column(name="post_id")
    private Integer id;
    @Column(name="status")
    @ColumnDefault(value="1")
    private PostStatus status;
    private Integer patchLogId;
    private Integer headPatchLogId;
    @Lob
    private String content;
    @Lob
    private String originalContent;

    protected void prePersist() {
        super.prePersist();
        if (this.originalContent == null) {
            this.originalContent = "";
        }
        if (this.content == null) {
            this.content = "";
        }
    }

    public Integer getId() {
        return this.id;
    }

    public PostStatus getStatus() {
        return this.status;
    }

    public Integer getPatchLogId() {
        return this.patchLogId;
    }

    public Integer getHeadPatchLogId() {
        return this.headPatchLogId;
    }

    public String getContent() {
        return this.content;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setStatus(PostStatus status) {
        this.status = status;
    }

    public void setPatchLogId(Integer patchLogId) {
        this.patchLogId = patchLogId;
    }

    public void setHeadPatchLogId(Integer headPatchLogId) {
        this.headPatchLogId = headPatchLogId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public String toString() {
        return "Content(id=" + this.getId() + ", status=" + this.getStatus() + ", patchLogId=" + this.getPatchLogId() + ", headPatchLogId=" + this.getHeadPatchLogId() + ", content=" + this.getContent() + ", originalContent=" + this.getOriginalContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Content)) {
            return false;
        }
        Content other = (Content)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$patchLogId = this.getPatchLogId();
        Integer other$patchLogId = other.getPatchLogId();
        if (this$patchLogId == null ? other$patchLogId != null : !((Object)this$patchLogId).equals(other$patchLogId)) {
            return false;
        }
        Integer this$headPatchLogId = this.getHeadPatchLogId();
        Integer other$headPatchLogId = other.getHeadPatchLogId();
        if (this$headPatchLogId == null ? other$headPatchLogId != null : !((Object)this$headPatchLogId).equals(other$headPatchLogId)) {
            return false;
        }
        PostStatus this$status = this.getStatus();
        PostStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$originalContent = this.getOriginalContent();
        String other$originalContent = other.getOriginalContent();
        return !(this$originalContent == null ? other$originalContent != null : !this$originalContent.equals(other$originalContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Content;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $patchLogId = this.getPatchLogId();
        result = result * 59 + ($patchLogId == null ? 43 : ((Object)$patchLogId).hashCode());
        Integer $headPatchLogId = this.getHeadPatchLogId();
        result = result * 59 + ($headPatchLogId == null ? 43 : ((Object)$headPatchLogId).hashCode());
        PostStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $originalContent = this.getOriginalContent();
        result = result * 59 + ($originalContent == null ? 43 : $originalContent.hashCode());
        return result;
    }
}

