/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.PostStatus;

@Entity
@Table(name="content_patch_logs", indexes={@Index(name="idx_post_id", columnList="post_id"), @Index(name="idx_status", columnList="status"), @Index(name="idx_version", columnList="version")})
public class ContentPatchLog
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="post_id")
    private Integer postId;
    @Lob
    @Column(name="content_diff")
    private String contentDiff;
    @Lob
    @Column(name="original_content_diff")
    private String originalContentDiff;
    @Column(name="version", nullable=false)
    private Integer version;
    @ColumnDefault(value="1")
    @Column(name="status")
    private PostStatus status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="publish_time")
    private Date publishTime;
    @Column(name="source_id", nullable=false)
    private Integer sourceId;

    protected void prePersist() {
        super.prePersist();
        if (this.version == null) {
            this.version = 1;
        }
        if (this.sourceId == null) {
            this.sourceId = 0;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getPostId() {
        return this.postId;
    }

    public String getContentDiff() {
        return this.contentDiff;
    }

    public String getOriginalContentDiff() {
        return this.originalContentDiff;
    }

    public Integer getVersion() {
        return this.version;
    }

    public PostStatus getStatus() {
        return this.status;
    }

    public Date getPublishTime() {
        return this.publishTime;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPostId(Integer postId) {
        this.postId = postId;
    }

    public void setContentDiff(String contentDiff) {
        this.contentDiff = contentDiff;
    }

    public void setOriginalContentDiff(String originalContentDiff) {
        this.originalContentDiff = originalContentDiff;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setStatus(PostStatus status) {
        this.status = status;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public String toString() {
        return "ContentPatchLog(id=" + this.getId() + ", postId=" + this.getPostId() + ", contentDiff=" + this.getContentDiff() + ", originalContentDiff=" + this.getOriginalContentDiff() + ", version=" + this.getVersion() + ", status=" + this.getStatus() + ", publishTime=" + this.getPublishTime() + ", sourceId=" + this.getSourceId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentPatchLog)) {
            return false;
        }
        ContentPatchLog other = (ContentPatchLog)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$postId = this.getPostId();
        Integer other$postId = other.getPostId();
        if (this$postId == null ? other$postId != null : !((Object)this$postId).equals(other$postId)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$sourceId = this.getSourceId();
        Integer other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        String this$contentDiff = this.getContentDiff();
        String other$contentDiff = other.getContentDiff();
        if (this$contentDiff == null ? other$contentDiff != null : !this$contentDiff.equals(other$contentDiff)) {
            return false;
        }
        String this$originalContentDiff = this.getOriginalContentDiff();
        String other$originalContentDiff = other.getOriginalContentDiff();
        if (this$originalContentDiff == null ? other$originalContentDiff != null : !this$originalContentDiff.equals(other$originalContentDiff)) {
            return false;
        }
        PostStatus this$status = this.getStatus();
        PostStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        return !(this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentPatchLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $postId = this.getPostId();
        result = result * 59 + ($postId == null ? 43 : ((Object)$postId).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        String $contentDiff = this.getContentDiff();
        result = result * 59 + ($contentDiff == null ? 43 : $contentDiff.hashCode());
        String $originalContentDiff = this.getOriginalContentDiff();
        result = result * 59 + ($originalContentDiff == null ? 43 : $originalContentDiff.hashCode());
        PostStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        return result;
    }
}

