/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.JournalType;

@Entity
@Table(name="journals")
public class Journal
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="source_content", nullable=false)
    @Lob
    private String sourceContent;
    @Column(name="content", nullable=false)
    @Lob
    private String content;
    @Column(name="likes")
    @ColumnDefault(value="0")
    private Long likes;
    @Column(name="type")
    @ColumnDefault(value="0")
    private JournalType type;

    public void prePersist() {
        super.prePersist();
        if (this.likes == null || this.likes < 0L) {
            this.likes = 0L;
        }
        if (this.type == null) {
            this.type = JournalType.PUBLIC;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getSourceContent() {
        return this.sourceContent;
    }

    public String getContent() {
        return this.content;
    }

    public Long getLikes() {
        return this.likes;
    }

    public JournalType getType() {
        return this.type;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSourceContent(String sourceContent) {
        this.sourceContent = sourceContent;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setLikes(Long likes) {
        this.likes = likes;
    }

    public void setType(JournalType type) {
        this.type = type;
    }

    public String toString() {
        return "Journal(super=" + super.toString() + ", id=" + this.getId() + ", sourceContent=" + this.getSourceContent() + ", content=" + this.getContent() + ", likes=" + this.getLikes() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Journal)) {
            return false;
        }
        Journal other = (Journal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$likes = this.getLikes();
        Long other$likes = other.getLikes();
        if (this$likes == null ? other$likes != null : !((Object)this$likes).equals(other$likes)) {
            return false;
        }
        String this$sourceContent = this.getSourceContent();
        String other$sourceContent = other.getSourceContent();
        if (this$sourceContent == null ? other$sourceContent != null : !this$sourceContent.equals(other$sourceContent)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        JournalType this$type = this.getType();
        JournalType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Journal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $likes = this.getLikes();
        result = result * 59 + ($likes == null ? 43 : ((Object)$likes).hashCode());
        String $sourceContent = this.getSourceContent();
        result = result * 59 + ($sourceContent == null ? 43 : $sourceContent.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        JournalType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

