/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;

@Entity
@Table(name="links", indexes={@Index(name="links_name", columnList="name")})
public class Link
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="url", length=1023, nullable=false)
    private String url;
    @Column(name="logo", length=1023)
    private String logo;
    @Column(name="description")
    private String description;
    @Column(name="team")
    private String team;
    @Column(name="priority")
    @ColumnDefault(value="0")
    private Integer priority;

    public void prePersist() {
        super.prePersist();
        if (this.priority == null) {
            this.priority = 0;
        }
        if (this.logo == null) {
            this.logo = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        if (this.team == null) {
            this.team = "";
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTeam() {
        return this.team;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String toString() {
        return "Link(id=" + this.getId() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", logo=" + this.getLogo() + ", description=" + this.getDescription() + ", team=" + this.getTeam() + ", priority=" + this.getPriority() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        return !(this$team == null ? other$team != null : !this$team.equals(other$team));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        return result;
    }
}

