/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.LogType;

@Entity
@Table(name="logs", indexes={@Index(name="logs_create_time", columnList="create_time")})
public class Log
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Long id;
    @Column(name="log_key", length=1023)
    private String logKey;
    @Column(name="type", nullable=false)
    private LogType type;
    @Column(name="content", length=1023, nullable=false)
    private String content;
    @Column(name="ip_address", length=127)
    private String ipAddress;

    public void prePersist() {
        super.prePersist();
        if (this.logKey == null) {
            this.logKey = "";
        }
        if (this.ipAddress == null) {
            this.logKey = "";
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getLogKey() {
        return this.logKey;
    }

    public LogType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLogKey(String logKey) {
        this.logKey = logKey;
    }

    public void setType(LogType type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String toString() {
        return "Log(id=" + this.getId() + ", logKey=" + this.getLogKey() + ", type=" + this.getType() + ", content=" + this.getContent() + ", ipAddress=" + this.getIpAddress() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$logKey = this.getLogKey();
        String other$logKey = other.getLogKey();
        if (this$logKey == null ? other$logKey != null : !this$logKey.equals(other$logKey)) {
            return false;
        }
        LogType this$type = this.getType();
        LogType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        return !(this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Log;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $logKey = this.getLogKey();
        result = result * 59 + ($logKey == null ? 43 : $logKey.hashCode());
        LogType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        return result;
    }
}

