/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;

@Entity
@Table(name="menus", indexes={@Index(name="menus_parent_id", columnList="parent_id"), @Index(name="menus_name", columnList="name")})
public class Menu
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="name", length=50, nullable=false)
    private String name;
    @Column(name="url", length=1023, nullable=false)
    private String url;
    @Column(name="priority")
    @ColumnDefault(value="0")
    private Integer priority;
    @Column(name="target", length=20)
    @ColumnDefault(value="'_self'")
    private String target;
    @Column(name="icon", length=50)
    private String icon;
    @Column(name="parent_id")
    @ColumnDefault(value="0")
    private Integer parentId;
    @Column(name="team")
    private String team;

    public void prePersist() {
        super.prePersist();
        if (this.priority == null) {
            this.priority = 0;
        }
        if (this.target == null) {
            this.target = "_self";
        }
        if (this.icon == null) {
            this.icon = "";
        }
        if (this.parentId == null) {
            this.parentId = 0;
        }
        if (this.team == null) {
            this.team = "";
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getTarget() {
        return this.target;
    }

    public String getIcon() {
        return this.icon;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String getTeam() {
        return this.team;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String toString() {
        return "Menu(id=" + this.getId() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", priority=" + this.getPriority() + ", target=" + this.getTarget() + ", icon=" + this.getIcon() + ", parentId=" + this.getParentId() + ", team=" + this.getTeam() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Menu)) {
            return false;
        }
        Menu other = (Menu)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        return !(this$team == null ? other$team != null : !this$team.equals(other$team));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Menu;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        return result;
    }
}

