/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;

@Entity
@Table(name="photos", indexes={@Index(name="photos_team", columnList="team"), @Index(name="photos_create_time", columnList="create_time")})
public class Photo
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="take_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date takeTime;
    @Column(name="location")
    private String location;
    @Column(name="thumbnail", length=1023)
    private String thumbnail;
    @Column(name="url", length=1023, nullable=false)
    private String url;
    @Column(name="team")
    private String team;
    @Column(name="likes", nullable=false)
    @ColumnDefault(value="0")
    private Long likes;

    public void prePersist() {
        super.prePersist();
        if (this.takeTime == null) {
            this.takeTime = this.getCreateTime();
        }
        if (this.description == null) {
            this.description = "";
        }
        if (this.location == null) {
            this.location = "";
        }
        if (this.thumbnail == null) {
            this.thumbnail = "";
        }
        if (this.team == null) {
            this.team = "";
        }
        if (this.likes == null || this.likes < 0L) {
            this.likes = 0L;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTakeTime() {
        return this.takeTime;
    }

    public String getLocation() {
        return this.location;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTeam() {
        return this.team;
    }

    public Long getLikes() {
        return this.likes;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTakeTime(Date takeTime) {
        this.takeTime = takeTime;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public void setLikes(Long likes) {
        this.likes = likes;
    }

    public String toString() {
        return "Photo(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", takeTime=" + this.getTakeTime() + ", location=" + this.getLocation() + ", thumbnail=" + this.getThumbnail() + ", url=" + this.getUrl() + ", team=" + this.getTeam() + ", likes=" + this.getLikes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Photo)) {
            return false;
        }
        Photo other = (Photo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$likes = this.getLikes();
        Long other$likes = other.getLikes();
        if (this$likes == null ? other$likes != null : !((Object)this$likes).equals(other$likes)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$takeTime = this.getTakeTime();
        Date other$takeTime = other.getTakeTime();
        if (this$takeTime == null ? other$takeTime != null : !((Object)this$takeTime).equals(other$takeTime)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        return !(this$team == null ? other$team != null : !this$team.equals(other$team));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Photo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $likes = this.getLikes();
        result = result * 59 + ($likes == null ? 43 : ((Object)$likes).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $takeTime = this.getTakeTime();
        result = result * 59 + ($takeTime == null ? 43 : ((Object)$takeTime).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        return result;
    }
}

