/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import run.halo.app.model.entity.BaseEntity;

@Entity
@Table(name="post_tags", indexes={@Index(name="post_tags_post_id", columnList="post_id"), @Index(name="post_tags_tag_id", columnList="tag_id")})
public class PostTag
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="custom-id")
    @GenericGenerator(name="custom-id", strategy="run.halo.app.model.entity.support.CustomIdGenerator")
    private Integer id;
    @Column(name="post_id", nullable=false)
    private Integer postId;
    @Column(name="tag_id", nullable=false)
    private Integer tagId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTag postTag = (PostTag)o;
        return Objects.equals(this.postId, postTag.postId) && Objects.equals(this.tagId, postTag.tagId);
    }

    public int hashCode() {
        return Objects.hash(this.postId, this.tagId);
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getPostId() {
        return this.postId;
    }

    public Integer getTagId() {
        return this.tagId;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPostId(Integer postId) {
        this.postId = postId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    public String toString() {
        return "PostTag(super=" + super.toString() + ", id=" + this.getId() + ", postId=" + this.getPostId() + ", tagId=" + this.getTagId() + ")";
    }
}

