/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.ColumnDefault;
import run.halo.app.model.entity.BaseEntity;
import run.halo.app.model.enums.MFAType;
import run.halo.app.utils.DateUtils;

@Entity
@Table(name="users")
public class User
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Column(name="username", length=50, nullable=false)
    private String username;
    @Column(name="nickname", nullable=false)
    private String nickname;
    @Column(name="password", nullable=false)
    private String password;
    @Column(name="email", length=127)
    private String email;
    @Column(name="avatar", length=1023)
    private String avatar;
    @Column(name="description", length=1023)
    private String description;
    @Column(name="expire_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expireTime;
    @Column(name="mfa_type", nullable=false)
    @ColumnDefault(value="0")
    private MFAType mfaType;
    @Column(name="mfa_key", length=64)
    private String mfaKey;

    public void prePersist() {
        super.prePersist();
        if (this.email == null) {
            this.email = "";
        }
        if (this.avatar == null) {
            this.avatar = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        if (this.expireTime == null) {
            this.expireTime = DateUtils.now();
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public MFAType getMfaType() {
        return this.mfaType;
    }

    public String getMfaKey() {
        return this.mfaKey;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public void setMfaType(MFAType mfaType) {
        this.mfaType = mfaType;
    }

    public void setMfaKey(String mfaKey) {
        this.mfaKey = mfaKey;
    }

    public String toString() {
        return "User(super=" + super.toString() + ", id=" + this.getId() + ", username=" + this.getUsername() + ", nickname=" + this.getNickname() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", avatar=" + this.getAvatar() + ", description=" + this.getDescription() + ", expireTime=" + this.getExpireTime() + ", mfaType=" + this.getMfaType() + ", mfaKey=" + this.getMfaKey() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$expireTime = this.getExpireTime();
        Date other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        MFAType this$mfaType = this.getMfaType();
        MFAType other$mfaType = other.getMfaType();
        if (this$mfaType == null ? other$mfaType != null : !this$mfaType.equals(other$mfaType)) {
            return false;
        }
        String this$mfaKey = this.getMfaKey();
        String other$mfaKey = other.getMfaKey();
        return !(this$mfaKey == null ? other$mfaKey != null : !this$mfaKey.equals(other$mfaKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        MFAType $mfaType = this.getMfaType();
        result = result * 59 + ($mfaType == null ? 43 : $mfaType.hashCode());
        String $mfaKey = this.getMfaKey();
        result = result * 59 + ($mfaKey == null ? 43 : $mfaKey.hashCode());
        return result;
    }
}

