/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.lang.reflect.ParameterizedType;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.URL;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.utils.ReflectionUtils;

public abstract class BaseCommentParam<COMMENT>
implements InputConverter<COMMENT> {
    @NotBlank(message="\u8bc4\u8bba\u8005\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=50, message="\u8bc4\u8bba\u8005\u6635\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @NotBlank(message="\u8bc4\u8bba\u8005\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=50, message="\u8bc4\u8bba\u8005\u6635\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String author;
    @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e")
    @Size(max=255, message="\u90ae\u7bb1\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e") @Size(max=255, message="\u90ae\u7bb1\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String email;
    @Size(max=255, message="\u8bc4\u8bba\u8005\u535a\u5ba2\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    @URL(message="\u535a\u5ba2\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Size(max=255, message="\u8bc4\u8bba\u8005\u535a\u5ba2\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") @URL(message="\u535a\u5ba2\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e") String authorUrl;
    @NotBlank(message="\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=1023, message="\u8bc4\u8bba\u5185\u5bb9\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @NotBlank(message="\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=1023, message="\u8bc4\u8bba\u5185\u5bb9\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String content;
    @Min(value=1L, message="Post id must not be less than {value}")
    private @Min(value=1L, message="Post id must not be less than {value}") Integer postId;
    @Min(value=0L, message="PostComment parent id must not be less than {value}")
    private @Min(value=0L, message="PostComment parent id must not be less than {value}") Long parentId = 0L;
    private Boolean allowNotification = true;

    public ParameterizedType parameterizedType() {
        return ReflectionUtils.getParameterizedTypeBySuperClass(BaseCommentParam.class, this.getClass());
    }

    public String getAuthor() {
        return this.author;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getPostId() {
        return this.postId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public Boolean getAllowNotification() {
        return this.allowNotification;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPostId(Integer postId) {
        this.postId = postId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setAllowNotification(Boolean allowNotification) {
        this.allowNotification = allowNotification;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCommentParam)) {
            return false;
        }
        BaseCommentParam other = (BaseCommentParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$postId = this.getPostId();
        Integer other$postId = other.getPostId();
        if (this$postId == null ? other$postId != null : !((Object)this$postId).equals(other$postId)) {
            return false;
        }
        Long this$parentId = this.getParentId();
        Long other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Boolean this$allowNotification = this.getAllowNotification();
        Boolean other$allowNotification = other.getAllowNotification();
        if (this$allowNotification == null ? other$allowNotification != null : !((Object)this$allowNotification).equals(other$allowNotification)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$authorUrl = this.getAuthorUrl();
        String other$authorUrl = other.getAuthorUrl();
        if (this$authorUrl == null ? other$authorUrl != null : !this$authorUrl.equals(other$authorUrl)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCommentParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $postId = this.getPostId();
        result = result * 59 + ($postId == null ? 43 : ((Object)$postId).hashCode());
        Long $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Boolean $allowNotification = this.getAllowNotification();
        result = result * 59 + ($allowNotification == null ? 43 : ((Object)$allowNotification).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $authorUrl = this.getAuthorUrl();
        result = result * 59 + ($authorUrl == null ? 43 : $authorUrl.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "BaseCommentParam(author=" + this.getAuthor() + ", email=" + this.getEmail() + ", authorUrl=" + this.getAuthorUrl() + ", content=" + this.getContent() + ", postId=" + this.getPostId() + ", parentId=" + this.getParentId() + ", allowNotification=" + this.getAllowNotification() + ")";
    }
}

