/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.util.Date;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.springframework.util.Assert;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.enums.PostEditorType;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.utils.MarkdownUtils;

public abstract class BasePostParam {
    protected String title;
    protected PostStatus status = PostStatus.DRAFT;
    protected String slug;
    protected String password;
    protected PostEditorType editorType;
    protected String content;
    protected String originalContent;
    protected String summary;
    @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    protected @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String thumbnail;
    protected Boolean disallowComment = false;
    @Size(max=255, message="\u6a21\u7248\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    protected @Size(max=255, message="\u6a21\u7248\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String template;
    @Min(value=0L, message="\u6392\u5e8f\u5b57\u6bb5\u503c\u4e0d\u80fd\u5c0f\u4e8e {value}")
    protected @Min(value=0L, message="\u6392\u5e8f\u5b57\u6bb5\u503c\u4e0d\u80fd\u5c0f\u4e8e {value}") Integer topPriority = 0;
    protected Date createTime;
    protected String metaKeywords;
    protected String metaDescription;
    protected Boolean keepRaw = false;

    protected <T extends BasePost> void populateContent(T post) {
        Assert.notNull(post, (String)"The post must not be null.");
        Content postContent = new Content();
        postContent.setOriginalContent(this.originalContent);
        if (Objects.equals(this.keepRaw, false) && PostEditorType.MARKDOWN.equals((Object)this.editorType)) {
            postContent.setContent(MarkdownUtils.renderHtml((String)this.originalContent));
        } else if (PostEditorType.RICHTEXT.equals((Object)this.editorType)) {
            postContent.setContent(this.originalContent);
        } else {
            postContent.setContent(this.content);
        }
        post.setContent(Content.PatchedContent.of((Content)postContent));
    }

    public String getTitle() {
        return this.title;
    }

    public PostStatus getStatus() {
        return this.status;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getPassword() {
        return this.password;
    }

    public PostEditorType getEditorType() {
        return this.editorType;
    }

    public String getContent() {
        return this.content;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public Boolean getDisallowComment() {
        return this.disallowComment;
    }

    public String getTemplate() {
        return this.template;
    }

    public Integer getTopPriority() {
        return this.topPriority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getMetaKeywords() {
        return this.metaKeywords;
    }

    public String getMetaDescription() {
        return this.metaDescription;
    }

    public Boolean getKeepRaw() {
        return this.keepRaw;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStatus(PostStatus status) {
        this.status = status;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEditorType(PostEditorType editorType) {
        this.editorType = editorType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setDisallowComment(Boolean disallowComment) {
        this.disallowComment = disallowComment;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setTopPriority(Integer topPriority) {
        this.topPriority = topPriority;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setMetaKeywords(String metaKeywords) {
        this.metaKeywords = metaKeywords;
    }

    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public void setKeepRaw(Boolean keepRaw) {
        this.keepRaw = keepRaw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePostParam)) {
            return false;
        }
        BasePostParam other = (BasePostParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$disallowComment = this.getDisallowComment();
        Boolean other$disallowComment = other.getDisallowComment();
        if (this$disallowComment == null ? other$disallowComment != null : !((Object)this$disallowComment).equals(other$disallowComment)) {
            return false;
        }
        Integer this$topPriority = this.getTopPriority();
        Integer other$topPriority = other.getTopPriority();
        if (this$topPriority == null ? other$topPriority != null : !((Object)this$topPriority).equals(other$topPriority)) {
            return false;
        }
        Boolean this$keepRaw = this.getKeepRaw();
        Boolean other$keepRaw = other.getKeepRaw();
        if (this$keepRaw == null ? other$keepRaw != null : !((Object)this$keepRaw).equals(other$keepRaw)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        PostStatus this$status = this.getStatus();
        PostStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        PostEditorType this$editorType = this.getEditorType();
        PostEditorType other$editorType = other.getEditorType();
        if (this$editorType == null ? other$editorType != null : !this$editorType.equals(other$editorType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$originalContent = this.getOriginalContent();
        String other$originalContent = other.getOriginalContent();
        if (this$originalContent == null ? other$originalContent != null : !this$originalContent.equals(other$originalContent)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$metaKeywords = this.getMetaKeywords();
        String other$metaKeywords = other.getMetaKeywords();
        if (this$metaKeywords == null ? other$metaKeywords != null : !this$metaKeywords.equals(other$metaKeywords)) {
            return false;
        }
        String this$metaDescription = this.getMetaDescription();
        String other$metaDescription = other.getMetaDescription();
        return !(this$metaDescription == null ? other$metaDescription != null : !this$metaDescription.equals(other$metaDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePostParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disallowComment = this.getDisallowComment();
        result = result * 59 + ($disallowComment == null ? 43 : ((Object)$disallowComment).hashCode());
        Integer $topPriority = this.getTopPriority();
        result = result * 59 + ($topPriority == null ? 43 : ((Object)$topPriority).hashCode());
        Boolean $keepRaw = this.getKeepRaw();
        result = result * 59 + ($keepRaw == null ? 43 : ((Object)$keepRaw).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        PostStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        PostEditorType $editorType = this.getEditorType();
        result = result * 59 + ($editorType == null ? 43 : $editorType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $originalContent = this.getOriginalContent();
        result = result * 59 + ($originalContent == null ? 43 : $originalContent.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $metaKeywords = this.getMetaKeywords();
        result = result * 59 + ($metaKeywords == null ? 43 : $metaKeywords.hashCode());
        String $metaDescription = this.getMetaDescription();
        result = result * 59 + ($metaDescription == null ? 43 : $metaDescription.hashCode());
        return result;
    }

    public String toString() {
        return "BasePostParam(title=" + this.getTitle() + ", status=" + this.getStatus() + ", slug=" + this.getSlug() + ", password=" + this.getPassword() + ", editorType=" + this.getEditorType() + ", content=" + this.getContent() + ", originalContent=" + this.getOriginalContent() + ", summary=" + this.getSummary() + ", thumbnail=" + this.getThumbnail() + ", disallowComment=" + this.getDisallowComment() + ", template=" + this.getTemplate() + ", topPriority=" + this.getTopPriority() + ", createTime=" + this.getCreateTime() + ", metaKeywords=" + this.getMetaKeywords() + ", metaDescription=" + this.getMetaDescription() + ", keepRaw=" + this.getKeepRaw() + ")";
    }
}

