/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.Category;
import run.halo.app.model.support.NotAllowSpaceOnly;
import run.halo.app.utils.SlugUtils;

public class CategoryParam
implements InputConverter<Category> {
    private Integer id;
    @NotBlank(message="\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=255, message="\u5206\u7c7b\u540d\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @NotBlank(message="\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=255, message="\u5206\u7c7b\u540d\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String name;
    @Size(max=255, message="\u5206\u7c7b\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Size(max=255, message="\u5206\u7c7b\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String slug;
    @Size(max=100, message="\u5206\u7c7b\u63cf\u8ff0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Size(max=100, message="\u5206\u7c7b\u63cf\u8ff0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String description;
    @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String thumbnail;
    @Size(max=255, message="\u5206\u7c7b\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    @NotAllowSpaceOnly(message="\u5bc6\u7801\u5f00\u5934\u548c\u7ed3\u5c3e\u4e0d\u80fd\u5305\u542b\u7a7a\u5b57\u7b26\u4e32")
    private @Size(max=255, message="\u5206\u7c7b\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String password;
    private Integer parentId = 0;
    @Min(value=0L, message="\u6392\u5e8f\u7f16\u53f7\u4e0d\u80fd\u4f4e\u4e8e {value}")
    private @Min(value=0L, message="\u6392\u5e8f\u7f16\u53f7\u4e0d\u80fd\u4f4e\u4e8e {value}") Integer priority;

    public Category convertTo() {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.name) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        return (Category)super.convertTo();
    }

    public void update(Category category) {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.name) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        super.update((Object)category);
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryParam)) {
            return false;
        }
        CategoryParam other = (CategoryParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "CategoryParam(id=" + this.getId() + ", name=" + this.getName() + ", slug=" + this.getSlug() + ", description=" + this.getDescription() + ", thumbnail=" + this.getThumbnail() + ", password=" + this.getPassword() + ", parentId=" + this.getParentId() + ", priority=" + this.getPriority() + ")";
    }
}

