/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.util.Objects;
import javax.validation.constraints.NotBlank;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.enums.JournalType;
import run.halo.app.utils.MarkdownUtils;

public class JournalParam
implements InputConverter<Journal> {
    @NotBlank(message="\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") String sourceContent;
    private String content;
    private JournalType type = JournalType.PUBLIC;
    private Boolean keepRaw = false;

    public Journal convertTo() {
        Journal journal = (Journal)super.convertTo();
        this.populateContent(journal);
        return journal;
    }

    public void update(Journal domain) {
        super.update((Object)domain);
        this.populateContent(domain);
    }

    private void populateContent(Journal journal) {
        if (Objects.equals(this.keepRaw, false)) {
            journal.setContent(MarkdownUtils.renderHtml((String)this.sourceContent));
        } else {
            journal.setContent(this.content);
        }
    }

    public String getSourceContent() {
        return this.sourceContent;
    }

    public String getContent() {
        return this.content;
    }

    public JournalType getType() {
        return this.type;
    }

    public Boolean getKeepRaw() {
        return this.keepRaw;
    }

    public void setSourceContent(String sourceContent) {
        this.sourceContent = sourceContent;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setType(JournalType type) {
        this.type = type;
    }

    public void setKeepRaw(Boolean keepRaw) {
        this.keepRaw = keepRaw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JournalParam)) {
            return false;
        }
        JournalParam other = (JournalParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$keepRaw = this.getKeepRaw();
        Boolean other$keepRaw = other.getKeepRaw();
        if (this$keepRaw == null ? other$keepRaw != null : !((Object)this$keepRaw).equals(other$keepRaw)) {
            return false;
        }
        String this$sourceContent = this.getSourceContent();
        String other$sourceContent = other.getSourceContent();
        if (this$sourceContent == null ? other$sourceContent != null : !this$sourceContent.equals(other$sourceContent)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        JournalType this$type = this.getType();
        JournalType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JournalParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $keepRaw = this.getKeepRaw();
        result = result * 59 + ($keepRaw == null ? 43 : ((Object)$keepRaw).hashCode());
        String $sourceContent = this.getSourceContent();
        result = result * 59 + ($sourceContent == null ? 43 : $sourceContent.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        JournalType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "JournalParam(sourceContent=" + this.getSourceContent() + ", content=" + this.getContent() + ", type=" + this.getType() + ", keepRaw=" + this.getKeepRaw() + ")";
    }
}

