/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import run.halo.app.model.enums.PostEditorType;
import run.halo.app.utils.MarkdownUtils;

public class PostContentParam {
    private String content;
    private String originalContent;
    private Boolean keepRaw = false;

    public String decideContentBy(PostEditorType editorType) {
        String originalContentToUse = StringUtils.defaultString((String)this.originalContent, (String)"");
        String result = Objects.equals(this.keepRaw, false) && PostEditorType.MARKDOWN.equals((Object)editorType) ? MarkdownUtils.renderHtml((String)originalContentToUse) : (PostEditorType.RICHTEXT.equals((Object)editorType) ? originalContentToUse : this.content);
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public Boolean getKeepRaw() {
        return this.keepRaw;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public void setKeepRaw(Boolean keepRaw) {
        this.keepRaw = keepRaw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostContentParam)) {
            return false;
        }
        PostContentParam other = (PostContentParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$keepRaw = this.getKeepRaw();
        Boolean other$keepRaw = other.getKeepRaw();
        if (this$keepRaw == null ? other$keepRaw != null : !((Object)this$keepRaw).equals(other$keepRaw)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$originalContent = this.getOriginalContent();
        String other$originalContent = other.getOriginalContent();
        return !(this$originalContent == null ? other$originalContent != null : !this$originalContent.equals(other$originalContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostContentParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $keepRaw = this.getKeepRaw();
        result = result * 59 + ($keepRaw == null ? 43 : ((Object)$keepRaw).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $originalContent = this.getOriginalContent();
        result = result * 59 + ($originalContent == null ? 43 : $originalContent.hashCode());
        return result;
    }

    public String toString() {
        return "PostContentParam(content=" + this.getContent() + ", originalContent=" + this.getOriginalContent() + ", keepRaw=" + this.getKeepRaw() + ")";
    }
}

