/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostMeta;
import run.halo.app.model.enums.PostEditorType;
import run.halo.app.model.params.BasePostParam;
import run.halo.app.model.params.PostMetaParam;
import run.halo.app.model.support.NotAllowSpaceOnly;
import run.halo.app.utils.SlugUtils;

public class PostParam
extends BasePostParam
implements InputConverter<Post> {
    private Set<Integer> tagIds;
    private Set<Integer> categoryIds;
    private Set<PostMetaParam> metas;

    @NotBlank(message="\u6587\u7ae0\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=100, message="\u6587\u7ae0\u6807\u9898\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    public @NotBlank(message="\u6587\u7ae0\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=100, message="\u6587\u7ae0\u6807\u9898\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getTitle() {
        return super.getTitle();
    }

    @Size(max=255, message="\u6587\u7ae0\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    public @Size(max=255, message="\u6587\u7ae0\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getSlug() {
        return super.getSlug();
    }

    @Size(max=255, message="\u6587\u7ae0\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    @NotAllowSpaceOnly(message="\u5bc6\u7801\u5f00\u5934\u548c\u7ed3\u5c3e\u4e0d\u80fd\u5305\u542b\u7a7a\u5b57\u7b26\u4e32")
    public @Size(max=255, message="\u6587\u7ae0\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getPassword() {
        return super.getPassword();
    }

    public Set<PostMeta> getPostMetas() {
        HashSet<PostMeta> postMetaSet = new HashSet<PostMeta>();
        if (CollectionUtils.isEmpty((Collection)this.metas)) {
            return postMetaSet;
        }
        for (PostMetaParam postMetaParam : this.metas) {
            PostMeta postMeta = (PostMeta)postMetaParam.convertTo();
            postMetaSet.add(postMeta);
        }
        return postMetaSet;
    }

    public Post convertTo() {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.title) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (null == this.editorType) {
            this.editorType = PostEditorType.MARKDOWN;
        }
        Post post = (Post)super.convertTo();
        this.populateContent((BasePost)post);
        return post;
    }

    public void update(Post post) {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.title) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (null == this.editorType) {
            this.editorType = PostEditorType.MARKDOWN;
        }
        this.populateContent((BasePost)post);
        super.update((Object)post);
    }

    public Set<Integer> getTagIds() {
        return this.tagIds;
    }

    public Set<Integer> getCategoryIds() {
        return this.categoryIds;
    }

    public Set<PostMetaParam> getMetas() {
        return this.metas;
    }

    public void setTagIds(Set<Integer> tagIds) {
        this.tagIds = tagIds;
    }

    public void setCategoryIds(Set<Integer> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public void setMetas(Set<PostMetaParam> metas) {
        this.metas = metas;
    }

    public String toString() {
        return "PostParam(tagIds=" + this.getTagIds() + ", categoryIds=" + this.getCategoryIds() + ", metas=" + this.getMetas() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostParam)) {
            return false;
        }
        PostParam other = (PostParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set this$tagIds = this.getTagIds();
        Set other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        Set this$categoryIds = this.getCategoryIds();
        Set other$categoryIds = other.getCategoryIds();
        if (this$categoryIds == null ? other$categoryIds != null : !((Object)this$categoryIds).equals(other$categoryIds)) {
            return false;
        }
        Set this$metas = this.getMetas();
        Set other$metas = other.getMetas();
        return !(this$metas == null ? other$metas != null : !((Object)this$metas).equals(other$metas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        Set $categoryIds = this.getCategoryIds();
        result = result * 59 + ($categoryIds == null ? 43 : ((Object)$categoryIds).hashCode());
        Set $metas = this.getMetas();
        result = result * 59 + ($metas == null ? 43 : ((Object)$metas).hashCode());
        return result;
    }
}

