/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetMeta;
import run.halo.app.model.enums.PostEditorType;
import run.halo.app.model.params.BasePostParam;
import run.halo.app.model.params.SheetMetaParam;
import run.halo.app.utils.SlugUtils;

public class SheetParam
extends BasePostParam
implements InputConverter<Sheet> {
    private Set<SheetMetaParam> metas;

    @Size(max=255, message="\u9875\u9762\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    public @Size(max=255, message="\u9875\u9762\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getSlug() {
        return super.getSlug();
    }

    @NotBlank(message="\u9875\u9762\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=100, message="\u9875\u9762\u6807\u9898\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    public @NotBlank(message="\u9875\u9762\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=100, message="\u9875\u9762\u6807\u9898\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getTitle() {
        return super.getTitle();
    }

    @Size(max=255, message="\u9875\u9762\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    public @Size(max=255, message="\u9875\u9762\u5bc6\u7801\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String getPassword() {
        return super.getPassword();
    }

    public Set<SheetMeta> getSheetMetas() {
        HashSet<SheetMeta> sheetMetasSet = new HashSet<SheetMeta>();
        if (CollectionUtils.isEmpty((Collection)this.metas)) {
            return sheetMetasSet;
        }
        for (SheetMetaParam sheetMetaParam : this.metas) {
            SheetMeta sheetMeta = (SheetMeta)sheetMetaParam.convertTo();
            sheetMetasSet.add(sheetMeta);
        }
        return sheetMetasSet;
    }

    public Sheet convertTo() {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.title) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (null == this.editorType) {
            this.editorType = PostEditorType.MARKDOWN;
        }
        Sheet sheet = (Sheet)super.convertTo();
        this.populateContent((BasePost)sheet);
        return sheet;
    }

    public void update(Sheet sheet) {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.title) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (null == this.editorType) {
            this.editorType = PostEditorType.MARKDOWN;
        }
        this.populateContent((BasePost)sheet);
        super.update((Object)sheet);
    }

    public Set<SheetMetaParam> getMetas() {
        return this.metas;
    }

    public void setMetas(Set<SheetMetaParam> metas) {
        this.metas = metas;
    }

    public String toString() {
        return "SheetParam(metas=" + this.getMetas() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SheetParam)) {
            return false;
        }
        SheetParam other = (SheetParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set this$metas = this.getMetas();
        Set other$metas = other.getMetas();
        return !(this$metas == null ? other$metas != null : !((Object)this$metas).equals(other$metas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SheetParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set $metas = this.getMetas();
        result = result * 59 + ($metas == null ? 43 : ((Object)$metas).hashCode());
        return result;
    }
}

