/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.model.params;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.Tag;
import run.halo.app.utils.SlugUtils;

public class TagParam
implements InputConverter<Tag> {
    @NotBlank(message="\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=255, message="\u6807\u7b7e\u540d\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @NotBlank(message="\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=255, message="\u6807\u7b7e\u540d\u79f0\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String name;
    @Size(max=255, message="\u6807\u7b7e\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Size(max=255, message="\u6807\u7b7e\u522b\u540d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String slug;
    @Size(max=24, message="\u989c\u8272\u503c\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    @ApiModelProperty(value="\u6807\u7b7e\u989c\u8272\uff0c\u652f\u6301\u591a\u79cd\u989c\u8272\u6a21\u5f0f\uff0c\u4f8b\u5982 Hex: #cfd3d7\uff0c\u989c\u8272\u540d\u79f0\uff1aLightGrey\uff0cRGB: rgb(207, 211, 215)\uff0cRGBA: rgb(207, 211, 215, 0.5)\u7b49", name="color", example="#e23d66")
    private @Size(max=24, message="\u989c\u8272\u503c\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String color;
    @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}")
    private @Size(max=1023, message="\u5c01\u9762\u56fe\u94fe\u63a5\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 {max}") String thumbnail;

    public Tag convertTo() {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.name) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (StringUtils.isBlank((CharSequence)this.color)) {
            this.color = "#cfd3d7";
        }
        return (Tag)super.convertTo();
    }

    public void update(Tag tag) {
        String string = this.slug = StringUtils.isBlank((CharSequence)this.slug) ? SlugUtils.slug((String)this.name) : SlugUtils.slug((String)this.slug);
        if (null == this.thumbnail) {
            this.thumbnail = "";
        }
        if (StringUtils.isBlank((CharSequence)this.color)) {
            this.color = "#cfd3d7";
        }
        super.update((Object)tag);
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getColor() {
        return this.color;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagParam)) {
            return false;
        }
        TagParam other = (TagParam)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        return result;
    }

    public String toString() {
        return "TagParam(name=" + this.getName() + ", slug=" + this.getSlug() + ", color=" + this.getColor() + ", thumbnail=" + this.getThumbnail() + ")";
    }
}

