/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.lang.NonNull;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.projection.CategoryIdPostStatusProjection;
import run.halo.app.repository.base.BaseRepository;

public interface PostCategoryRepository
extends BaseRepository<PostCategory, Integer> {
    @NonNull
    @Query(value="select postCategory.categoryId from PostCategory postCategory where postCategory.postId = ?1")
    public Set<Integer> findAllCategoryIdsByPostId(@NonNull Integer var1);

    @NonNull
    @Query(value="select postCategory.postId from PostCategory postCategory where postCategory.categoryId = ?1")
    public Set<Integer> findAllPostIdsByCategoryId(@NonNull Integer var1);

    @NonNull
    @Query(value="select postCategory.postId from PostCategory postCategory, Post post where postCategory.categoryId = ?1 and post.id = postCategory.postId and post.status = ?2")
    public Set<Integer> findAllPostIdsByCategoryId(@NonNull Integer var1, @NonNull PostStatus var2);

    @NonNull
    @Query(value="select postCategory.postId from PostCategory postCategory, Post post where postCategory.categoryId = ?1 and post.id = postCategory.postId and post.status in (?2)")
    public Set<Integer> findAllPostIdsByCategoryId(@NonNull Integer var1, @NonNull Set<PostStatus> var2);

    @NonNull
    public List<PostCategory> findAllByPostIdIn(@NonNull Collection<Integer> var1);

    @NonNull
    public List<PostCategory> findAllByPostId(@NonNull Integer var1);

    @NonNull
    public List<PostCategory> findAllByCategoryId(@NonNull Integer var1);

    @NonNull
    public List<PostCategory> deleteByPostId(@NonNull Integer var1);

    @NonNull
    public List<PostCategory> deleteByCategoryId(@NonNull Integer var1);

    @Query(value="select pc from PostCategory pc where pc.categoryId in (?1)")
    @NonNull
    public List<PostCategory> findAllByCategoryIdList(List<Integer> var1);

    @NonNull
    @Query(value="select new run.halo.app.model.projection.CategoryIdPostStatusProjection(pc.categoryId, pc.postId, p.status) from PostCategory pc inner join Post p on p.id=pc.postId")
    public List<CategoryIdPostStatusProjection> findAllWithPostStatus();
}

