/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.lang.NonNull;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.projection.CommentChildrenCountProjection;
import run.halo.app.model.projection.CommentCountProjection;
import run.halo.app.repository.base.BaseCommentRepository;

public interface PostCommentRepository
extends BaseCommentRepository<PostComment> {
    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from PostComment comment where comment.postId in ?1 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByPostIds(@NonNull Collection<Integer> var1);

    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from PostComment comment where comment.status = ?1 and comment.postId in ?2 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByStatusAndPostIds(@NonNull CommentStatus var1, @NonNull Collection<Integer> var2);

    @Query(value="select new run.halo.app.model.projection.CommentChildrenCountProjection(count(comment.id), comment.parentId) from PostComment comment where comment.parentId in ?1 group by comment.parentId")
    @NonNull
    public List<CommentChildrenCountProjection> findDirectChildrenCount(@NonNull Collection<Long> var1);

    @Query(value="SELECT COUNT(id) FROM PostComment WHERE ipAddress=?1 AND updateTime BETWEEN ?2 AND ?3 AND status <> 2")
    public int countByIpAndTime(String var1, Date var2, Date var3);
}

