/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.util.Optional;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.repository.base.BasePostRepository;

public interface PostRepository
extends BasePostRepository<Post>,
JpaSpecificationExecutor<Post> {
    @Query(value="select sum(p.visits) from Post p")
    public Long countVisit();

    @Query(value="select sum(p.likes) from Post p")
    public Long countLike();

    @Query(value="select post from Post post where year(post.createTime) = :year and month(post.createTime) = :month and post.slug = :slug")
    public Optional<Post> findBy(@Param(value="year") Integer var1, @Param(value="month") Integer var2, @Param(value="slug") String var3);

    @Query(value="select post from Post post where year(post.createTime) = :year and post.slug = :slug")
    public Optional<Post> findBy(@Param(value="year") Integer var1, @Param(value="slug") String var2);

    @Query(value="select post from Post post where year(post.createTime) = :year and month(post.createTime) = :month and post.slug = :slug and post.status = :status")
    public Optional<Post> findBy(@Param(value="year") Integer var1, @Param(value="month") Integer var2, @Param(value="slug") String var3, @Param(value="status") PostStatus var4);

    @Query(value="select post from Post post where year(post.createTime) = :year and month(post.createTime) = :month and day(post.createTime) = :day and post.slug = :slug")
    public Optional<Post> findBy(@Param(value="year") Integer var1, @Param(value="month") Integer var2, @Param(value="day") Integer var3, @Param(value="slug") String var4);

    @Query(value="select post from Post post where year(post.createTime) = :year and month(post.createTime) = :month and day(post.createTime) = :day and post.slug = :slug and post.status = :status")
    public Optional<Post> findBy(@Param(value="year") Integer var1, @Param(value="month") Integer var2, @Param(value="day") Integer var3, @Param(value="slug") String var4, @Param(value="status") PostStatus var5);
}

