/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.lang.NonNull;
import run.halo.app.model.entity.PostTag;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.projection.TagPostPostCountProjection;
import run.halo.app.repository.base.BaseRepository;

public interface PostTagRepository
extends BaseRepository<PostTag, Integer> {
    @NonNull
    public List<PostTag> findAllByPostId(@NonNull Integer var1);

    @Query(value="select postTag.tagId from PostTag postTag where postTag.postId = ?1")
    @NonNull
    public Set<Integer> findAllTagIdsByPostId(@NonNull Integer var1);

    @NonNull
    public List<PostTag> findAllByTagId(@NonNull Integer var1);

    @Query(value="select postTag.postId from PostTag postTag where postTag.tagId = ?1")
    @NonNull
    public Set<Integer> findAllPostIdsByTagId(@NonNull Integer var1);

    @Query(value="select postTag.postId from PostTag postTag,Post post where postTag.tagId = ?1 and post.id = postTag.postId and post.status = ?2")
    @NonNull
    public Set<Integer> findAllPostIdsByTagId(@NonNull Integer var1, @NonNull PostStatus var2);

    @NonNull
    public List<PostTag> findAllByPostIdIn(@NonNull Collection<Integer> var1);

    @NonNull
    public List<PostTag> deleteByPostId(@NonNull Integer var1);

    @NonNull
    public List<PostTag> deleteByTagId(@NonNull Integer var1);

    @Query(value="select new run.halo.app.model.projection.TagPostPostCountProjection(count(pt.postId), pt.tagId) from PostTag pt where pt.tagId in ?1 group by pt.tagId")
    @NonNull
    public List<TagPostPostCountProjection> findPostCountByTagIds(@NonNull Collection<Integer> var1);

    @Query(value="select new run.halo.app.model.projection.TagPostPostCountProjection(count(pt.postId), pt.tagId) from PostTag pt inner join Post p on p.id=pt.postId and p.status<>2 group by pt.tagId")
    @NonNull
    public List<TagPostPostCountProjection> findPostCount();
}

