/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.lang.NonNull;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.projection.CommentChildrenCountProjection;
import run.halo.app.model.projection.CommentCountProjection;
import run.halo.app.repository.base.BaseCommentRepository;

public interface SheetCommentRepository
extends BaseCommentRepository<SheetComment> {
    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from SheetComment comment where comment.postId in ?1 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByPostIds(@NonNull Collection<Integer> var1);

    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from SheetComment comment where comment.status = ?1 and comment.postId in ?2 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByStatusAndPostIds(@NonNull CommentStatus var1, @NonNull Collection<Integer> var2);

    @Query(value="select new run.halo.app.model.projection.CommentChildrenCountProjection(count(comment.id), comment.parentId) from SheetComment comment where comment.parentId in ?1 group by comment.parentId")
    @NonNull
    public List<CommentChildrenCountProjection> findDirectChildrenCount(@NonNull Collection<Long> var1);
}

