/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.options.OptionUpdatedEvent;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.exception.ThemeNotFoundException;
import run.halo.app.exception.ThemeNotSupportException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.model.entity.Option;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.support.HaloConst;
import run.halo.app.repository.OptionRepository;
import run.halo.app.repository.ThemeRepository;
import run.halo.app.theme.ThemePropertyScanner;
import run.halo.app.utils.FileUtils;
import run.halo.app.utils.Version;

@Repository
public class ThemeRepositoryImpl
implements ThemeRepository,
ApplicationListener<OptionUpdatedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ThemeRepositoryImpl.class);
    private final OptionRepository optionRepository;
    private final HaloProperties properties;
    private final ApplicationEventPublisher eventPublisher;
    private volatile ThemeProperty currentTheme;

    public ThemeRepositoryImpl(OptionRepository optionRepository, HaloProperties properties, ApplicationEventPublisher eventPublisher) {
        this.optionRepository = optionRepository;
        this.properties = properties;
        this.eventPublisher = eventPublisher;
    }

    public String getActivatedThemeId() {
        return this.optionRepository.findByKey(PrimaryProperties.THEME.getValue()).map(Option::getValue).orElse("caicai_anatole");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeProperty getActivatedThemeProperty() {
        ThemeProperty themeProperty = this.currentTheme;
        if (themeProperty == null) {
            AtomicBoolean fallbackTheme = new AtomicBoolean(false);
            ThemeRepositoryImpl themeRepositoryImpl = this;
            synchronized (themeRepositoryImpl) {
                if (this.currentTheme == null) {
                    String currentThemeId = this.getActivatedThemeId();
                    this.currentTheme = this.fetchThemePropertyByThemeId(currentThemeId).orElseGet(() -> {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)currentThemeId, (CharSequence)"caicai_anatole")) {
                            fallbackTheme.set(true);
                            return this.getThemeByThemeId("caicai_anatole");
                        }
                        throw new ThemeNotFoundException("Default theme: caicai_anatole was not found!");
                    });
                }
            }
            if (fallbackTheme.get()) {
                this.setActivatedTheme("caicai_anatole");
            }
        }
        return this.currentTheme;
    }

    public Optional<ThemeProperty> fetchThemePropertyByThemeId(String themeId) {
        return this.listAll().stream().filter(property -> Objects.equals(themeId, property.getId())).findFirst();
    }

    public List<ThemeProperty> listAll() {
        return ThemePropertyScanner.INSTANCE.scan(this.getThemeRootPath(), this.getActivatedThemeId());
    }

    public void setActivatedTheme(@NonNull String themeId) {
        Assert.hasText((String)themeId, (String)"Theme id must not be blank");
        Option newThemeOption = this.optionRepository.findByKey(PrimaryProperties.THEME.getValue()).map(themeOption -> {
            themeOption.setValue(themeId);
            return themeOption;
        }).orElseGet(() -> new Option(PrimaryProperties.THEME.getValue(), themeId));
        this.optionRepository.save((Object)newThemeOption);
        this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
    }

    public ThemeProperty attemptToAdd(ThemeProperty newProperty) {
        boolean alreadyExist = this.fetchThemePropertyByThemeId(newProperty.getId()).isPresent();
        if (alreadyExist) {
            throw new AlreadyExistsException("\u5f53\u524d\u5b89\u88c5\u7684\u4e3b\u9898\u5df2\u5b58\u5728");
        }
        if (!this.checkThemePropertyCompatibility(newProperty)) {
            throw new ThemeNotSupportException("\u5f53\u524d\u4e3b\u9898\u4ec5\u652f\u6301 Halo " + newProperty.getRequire() + " \u53ca\u4ee5\u4e0a\u7684\u7248\u672c");
        }
        Path sourceThemePath = Paths.get(newProperty.getThemePath(), new String[0]);
        Path targetThemePath = this.getThemeRootPath().resolve(newProperty.getId());
        FileUtils.deleteFolderQuietly((Path)targetThemePath);
        log.info("Copying new theme({}) from {} to {}", new Object[]{newProperty.getId(), sourceThemePath, targetThemePath});
        try {
            FileUtils.copyFolder((Path)sourceThemePath, (Path)targetThemePath);
        }
        catch (IOException e) {
            FileUtils.deleteFolderQuietly((Path)targetThemePath);
            throw new ServiceException("\u590d\u5236\u4e3b\u9898\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            log.info("Clean temporary theme folder {}", (Object)sourceThemePath);
            FileUtils.deleteFolderQuietly((Path)sourceThemePath);
        }
        return (ThemeProperty)ThemePropertyScanner.INSTANCE.fetchThemeProperty(targetThemePath).orElseThrow();
    }

    public void deleteTheme(String themeId) {
        ThemeProperty themeProperty = (ThemeProperty)this.fetchThemePropertyByThemeId(themeId).orElseThrow(() -> new NotFoundException("\u4e3b\u9898 ID \u4e3a " + themeId + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01"));
        this.deleteTheme(themeProperty);
    }

    public void deleteTheme(ThemeProperty themeProperty) {
        Path themePath = Paths.get(themeProperty.getThemePath(), new String[0]);
        try {
            FileUtils.deleteFolder((Path)themePath);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to delete theme path: " + themePath, (Throwable)e);
        }
    }

    public boolean checkThemePropertyCompatibility(ThemeProperty themeProperty) {
        String requiredVersion = themeProperty.getRequire();
        return Version.resolve((String)HaloConst.HALO_VERSION).map(current -> current.compatible(requiredVersion)).orElse(false);
    }

    private Path getThemeRootPath() {
        return Paths.get(this.properties.getWorkDir(), new String[0]).resolve("templates/themes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(OptionUpdatedEvent event) {
        ThemeRepositoryImpl themeRepositoryImpl = this;
        synchronized (themeRepositoryImpl) {
            this.currentTheme = null;
        }
    }

    @NonNull
    protected ThemeProperty getThemeByThemeId(String themeId) {
        return (ThemeProperty)this.fetchThemePropertyByThemeId(themeId).orElseThrow(() -> new ThemeNotFoundException("Failed to find theme with id: " + themeId));
    }
}

